/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import fr.brouillard.oss.jgitver.metadata.TagType;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ConfigurableVersionStrategy
extends VersionStrategy {
    private boolean autoIncrementPatch = false;
    private boolean useDistance = true;
    private boolean useCommitTimestamp = false;
    private boolean useGitCommitId = false;
    private int gitCommitIdLength = 8;
    private boolean useDirty = false;
    private boolean useLongFormat;

    public ConfigurableVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar metadatas) {
        super(vnc, repository, git, metadatas);
    }

    public ConfigurableVersionStrategy setAutoIncrementPatch(boolean autoIncrementPatch) {
        this.autoIncrementPatch = autoIncrementPatch;
        return this;
    }

    public ConfigurableVersionStrategy setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
        return this;
    }

    public ConfigurableVersionStrategy setUseCommitTimestamp(boolean useCommitTimestamp) {
        this.useCommitTimestamp = useCommitTimestamp;
        return this;
    }

    public ConfigurableVersionStrategy setUseGitCommitId(boolean useGitCommitId) {
        this.useGitCommitId = useGitCommitId;
        return this;
    }

    public ConfigurableVersionStrategy setGitCommitIdLength(int gitCommitIdLength) {
        this.gitCommitIdLength = gitCommitIdLength;
        return this;
    }

    public ConfigurableVersionStrategy setUseDirty(boolean useDirty) {
        this.useDirty = useDirty;
        return this;
    }

    public ConfigurableVersionStrategy setUseLongFormat(boolean useLongFormat) {
        this.useLongFormat = useLongFormat;
        return this;
    }

    @Override
    public Version build(Commit head, List<Commit> parents) throws VersionCalculationException {
        try {
            boolean needsCommitId;
            Version baseVersion;
            Commit base = parents.get(0);
            Ref tagToUse = this.isBaseCommitOnHead(head, base) && !GitUtils.isDirty(this.getGit()) ? base.getAnnotatedTags().stream().findFirst().orElseGet(() -> base.getLightTags().stream().findFirst().orElse(null)) : base.getLightTags().stream().findFirst().orElseGet(() -> base.getAnnotatedTags().stream().findFirst().orElse(null));
            if (tagToUse == null) {
                baseVersion = Version.DEFAULT_VERSION;
            } else {
                String tagName = GitUtils.tagNameFromRef(tagToUse);
                TagType tagType = this.computeTagType(tagToUse, base.getAnnotatedTags().stream().findFirst().orElse(null));
                this.getRegistrar().registerMetadata(Metadatas.BASE_TAG_TYPE, tagType.name());
                this.getRegistrar().registerMetadata(Metadatas.BASE_TAG, tagName);
                baseVersion = Version.parse(this.getVersionNamingConfiguration().extractVersionFrom(tagName));
            }
            this.getRegistrar().registerMetadata(Metadatas.BASE_VERSION, baseVersion.toString());
            boolean useSnapshot = baseVersion.isSnapshot();
            if (!this.isBaseCommitOnHead(head, base) && this.autoIncrementPatch && !this.useLongFormat && GitUtils.isAnnotated(tagToUse)) {
                baseVersion = baseVersion.incrementPatch();
            }
            if ((this.useDistance || this.useLongFormat) && !useSnapshot) {
                if (tagToUse == null) {
                    baseVersion = baseVersion.addQualifier("" + base.getHeadDistance());
                } else if (this.useLongFormat || !this.isBaseCommitOnHead(head, base) || !GitUtils.isAnnotated(tagToUse)) {
                    baseVersion = baseVersion.addQualifier("" + base.getHeadDistance());
                }
            }
            this.getRegistrar().registerMetadata(Metadatas.COMMIT_DISTANCE, "" + base.getHeadDistance());
            boolean needsCommitTimestamp = this.useCommitTimestamp && !useSnapshot;
            try (RevWalk walk = new RevWalk(this.getRepository());){
                RevCommit rc = walk.parseCommit((AnyObjectId)head.getGitObject());
                String commitTimestamp = GitUtils.getTimestamp(rc.getAuthorIdent().getWhen().toInstant());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_TIMESTAMP, commitTimestamp);
                if (needsCommitTimestamp) {
                    baseVersion = baseVersion.addQualifier(commitTimestamp);
                }
            }
            boolean bl = needsCommitId = this.useGitCommitId && (!this.isBaseCommitOnHead(head, base) || baseVersion.noQualifier().equals(Version.DEFAULT_VERSION));
            if (this.useLongFormat || needsCommitId) {
                String commitIdQualifier = (this.useLongFormat ? "g" : "") + head.getGitObject().getName().substring(0, this.useLongFormat ? 8 : this.gitCommitIdLength);
                baseVersion = baseVersion.addQualifier(commitIdQualifier);
            }
            if (!GitUtils.isDetachedHead(this.getRepository())) {
                String branch = this.getRepository().getBranch();
                baseVersion = this.enhanceVersionWithBranch(baseVersion, branch);
            } else {
                Optional<String> externalyProvidedBranchName = GitUtils.providedBranchName();
                if (externalyProvidedBranchName.isPresent()) {
                    baseVersion = this.enhanceVersionWithBranch(baseVersion, externalyProvidedBranchName.get());
                }
            }
            if (this.useDirty && GitUtils.isDirty(this.getGit())) {
                baseVersion = baseVersion.addQualifier("dirty");
            }
            return useSnapshot ? baseVersion.removeQualifier("SNAPSHOT").addQualifier("SNAPSHOT") : baseVersion;
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }
}

