/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import fr.brouillard.oss.jgitver.metadata.TagType;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class MavenVersionStrategy
extends VersionStrategy {
    private boolean useDirty = false;

    public MavenVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar metadatas) {
        super(vnc, repository, git, metadatas);
    }

    @Override
    public Version build(Commit head, List<Commit> parentsWithTags) throws VersionCalculationException {
        try {
            Commit base = parentsWithTags.get(0);
            Ref tagToUse = this.isBaseCommitOnHead(head, base) && !GitUtils.isDirty(this.getGit()) ? base.getAnnotatedTags().stream().findFirst().orElseGet(() -> base.getLightTags().stream().findFirst().orElse(null)) : base.getLightTags().stream().findFirst().orElseGet(() -> base.getAnnotatedTags().stream().findFirst().orElse(null));
            Version baseVersion = null;
            boolean needSnapshot = false;
            if (tagToUse == null) {
                baseVersion = Version.DEFAULT_VERSION;
                needSnapshot = true;
            } else {
                String tagName = GitUtils.tagNameFromRef(tagToUse);
                TagType tagType = this.computeTagType(tagToUse, base.getAnnotatedTags().stream().findFirst().orElse(null));
                this.getRegistrar().registerMetadata(Metadatas.BASE_TAG, tagName);
                this.getRegistrar().registerMetadata(Metadatas.BASE_TAG_TYPE, tagType.name());
                baseVersion = Version.parse(this.getVersionNamingConfiguration().extractVersionFrom(tagName));
                needSnapshot = baseVersion.isSnapshot() || !this.isBaseCommitOnHead(head, base) || !GitUtils.isAnnotated(tagToUse);
            }
            this.getRegistrar().registerMetadata(Metadatas.BASE_VERSION, baseVersion.toString());
            if (!this.isBaseCommitOnHead(head, base)) {
                if (GitUtils.isAnnotated(tagToUse) && !baseVersion.removeQualifier("SNAPSHOT").isQualified()) {
                    baseVersion = baseVersion.incrementPatch();
                }
                baseVersion = baseVersion.noQualifier();
            }
            if (!GitUtils.isDetachedHead(this.getRepository())) {
                String branch = this.getRepository().getBranch();
                baseVersion = this.enhanceVersionWithBranch(baseVersion, branch);
            } else {
                Optional<String> externalyProvidedBranchName = GitUtils.providedBranchName();
                if (externalyProvidedBranchName.isPresent()) {
                    baseVersion = this.enhanceVersionWithBranch(baseVersion, externalyProvidedBranchName.get());
                }
            }
            if (this.useDirty && GitUtils.isDirty(this.getGit())) {
                baseVersion = baseVersion.addQualifier("dirty");
            }
            try (RevWalk walk = new RevWalk(this.getRepository());){
                RevCommit rc = walk.parseCommit((AnyObjectId)head.getGitObject());
                String commitTimestamp = GitUtils.getTimestamp(rc.getAuthorIdent().getWhen().toInstant());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_TIMESTAMP, commitTimestamp);
            }
            return needSnapshot ? baseVersion.removeQualifier("SNAPSHOT").addQualifier("SNAPSHOT") : baseVersion;
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }

    public void setUseDirty(boolean useDirty) {
        this.useDirty = useDirty;
    }
}

