/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar;

import java.util.ArrayList;
import java.util.List;

public final class HypergraphPartition {
    private final int numberOfBlocks;
    private final int[] blockIdentifiers;
    private List<List<Integer>> blocks;
    private final int objectiveValue;

    HypergraphPartition(int numberOfBlocks, int[] blockIdentifiers, int objectiveValue) {
        this.numberOfBlocks = numberOfBlocks;
        this.blockIdentifiers = blockIdentifiers;
        this.objectiveValue = objectiveValue;
    }

    public int blockOf(int vertex) {
        return this.blockIdentifiers[vertex - 1];
    }

    public int objectiveValue() {
        return this.objectiveValue;
    }

    public List<List<Integer>> getBlocks() {
        if (this.blocks == null) {
            this.blocks = this.computeBlocks();
        }
        return this.blocks;
    }

    private List<List<Integer>> computeBlocks() {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>(this.numberOfBlocks);
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            result.add(new ArrayList());
        }
        for (int v = 0; v < this.blockIdentifiers.length; ++v) {
            result.get(this.blockIdentifiers[v]).add(v + 1);
        }
        return result;
    }
}

