/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.hypergraph;

import fr.univartois.cril.jkahypar.hypergraph.AbstractHypergraph;
import fr.univartois.cril.jkahypar.hypergraph.Hyperedge;
import fr.univartois.cril.jkahypar.hypergraph.Hypergraph;
import fr.univartois.cril.jkahypar.hypergraph.HypergraphBuilder;
import fr.univartois.cril.jkahypar.hypergraph.UnweightedHyperedge;
import fr.univartois.cril.jkahypar.hypergraph.UnweightedHypergraph;
import fr.univartois.cril.jkahypar.hypergraph.WeightedHyperedge;
import fr.univartois.cril.jkahypar.hypergraph.WeightedHyperedgesHypergraph;
import fr.univartois.cril.jkahypar.hypergraph.WeightedVerticesHypergraph;
import java.util.Arrays;

public abstract class AbstractHypergraphBuilder
implements HypergraphBuilder {
    protected int numberOfVertices;
    protected int[] vertexWeights;
    protected int numberOfHyperedges;
    protected int[] hyperedgeWeights;
    protected long[] hyperedgeIndices;
    protected int[] hyperedgeVertices;
    private int hyperedgeIndex;
    private int hyperedgeVerticesIndex;

    protected AbstractHypergraphBuilder(int nbVertices, int nbHyperedges) {
        this.numberOfVertices = nbVertices;
        this.numberOfHyperedges = nbHyperedges;
        this.hyperedgeIndices = new long[nbHyperedges + 1];
        this.hyperedgeVertices = new int[(nbHyperedges << 1) + 1];
    }

    @Override
    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public int getNumberOfHyperedges() {
        return this.numberOfHyperedges;
    }

    @Override
    public long[] getHyperedgeIndices() {
        return this.hyperedgeIndices;
    }

    @Override
    public int[] getHyperedgeVertices() {
        return this.hyperedgeVertices;
    }

    @Override
    public HypergraphBuilder withHyperedge(UnweightedHyperedge hyperedge) {
        this.appendVertices(hyperedge);
        return this;
    }

    @Override
    public HypergraphBuilder withHyperedge(WeightedHyperedge hyperedge) {
        this.withHyperedgeWeight(this.hyperedgeIndex, hyperedge.getWeight());
        this.appendVertices(hyperedge);
        return this;
    }

    protected abstract void setHyperedgeIndex(int var1, int var2);

    protected abstract HypergraphBuilder withHyperedgeWeight(int var1, int var2);

    protected void appendVertices(Hyperedge hyperedge) {
        this.setHyperedgeIndex(this.hyperedgeIndex, this.hyperedgeVerticesIndex);
        for (int vertex : hyperedge.getVertices()) {
            this.appendVertex(vertex);
        }
        ++this.hyperedgeIndex;
    }

    protected void appendVertex(int vertex) {
        if (this.hyperedgeVertices.length == this.hyperedgeVerticesIndex) {
            this.hyperedgeVertices = Arrays.copyOf(this.hyperedgeVertices, this.hyperedgeVerticesIndex << 1);
        }
        this.hyperedgeVertices[this.hyperedgeVerticesIndex++] = vertex - 1;
    }

    @Override
    public Hypergraph build() {
        this.setHyperedgeIndex(this.hyperedgeIndex, this.hyperedgeVerticesIndex);
        this.hyperedgeVertices = Arrays.copyOf(this.hyperedgeVertices, this.hyperedgeVerticesIndex);
        this.resizeArrays();
        AbstractHypergraph hypergraph = new UnweightedHypergraph(this);
        if (this.hyperedgeWeights != null) {
            hypergraph = new WeightedHyperedgesHypergraph(hypergraph, this.hyperedgeWeights);
        }
        if (this.vertexWeights != null) {
            hypergraph = new WeightedVerticesHypergraph(hypergraph, this.vertexWeights);
        }
        return hypergraph;
    }

    protected abstract void resizeArrays();
}

