/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.hypergraph;

import fr.univartois.cril.jkahypar.hypergraph.AbstractHypergraphBuilder;
import fr.univartois.cril.jkahypar.hypergraph.HypergraphBuilder;
import java.util.Arrays;

final class UnknownSizeHypergraphBuilder
extends AbstractHypergraphBuilder {
    UnknownSizeHypergraphBuilder() {
        super(0, 0);
    }

    @Override
    public HypergraphBuilder withVertexWeight(int vertex, int weight) {
        if (this.vertexWeights == null) {
            this.vertexWeights = new int[this.numberOfVertices];
        }
        if (this.vertexWeights.length < vertex) {
            this.vertexWeights = Arrays.copyOf(this.vertexWeights, vertex << 1);
        }
        this.numberOfVertices = Math.max(this.numberOfVertices, vertex);
        this.vertexWeights[vertex - 1] = weight;
        return this;
    }

    @Override
    protected void setHyperedgeIndex(int index, int vertexIndex) {
        int hyperedgeId = index + 1;
        if (this.hyperedgeIndices.length < hyperedgeId) {
            this.hyperedgeIndices = Arrays.copyOf(this.hyperedgeIndices, hyperedgeId << 1);
        }
        this.numberOfHyperedges = Math.max(this.numberOfHyperedges, hyperedgeId);
        this.hyperedgeIndices[index] = vertexIndex;
    }

    @Override
    protected HypergraphBuilder withHyperedgeWeight(int hyperedge, int weight) {
        int hyperedgeId;
        if (this.hyperedgeWeights == null) {
            this.hyperedgeWeights = new int[this.numberOfHyperedges];
        }
        if (this.hyperedgeWeights.length < (hyperedgeId = hyperedge + 1)) {
            this.hyperedgeWeights = Arrays.copyOf(this.hyperedgeWeights, hyperedgeId << 1);
        }
        this.numberOfHyperedges = Math.max(this.numberOfHyperedges, hyperedgeId);
        this.hyperedgeWeights[hyperedge] = weight;
        return this;
    }

    @Override
    protected void appendVertex(int vertex) {
        super.appendVertex(vertex);
        this.numberOfVertices = Math.max(this.numberOfVertices, vertex);
    }

    @Override
    protected void resizeArrays() {
        this.hyperedgeIndices = Arrays.copyOf(this.hyperedgeIndices, this.numberOfHyperedges);
        --this.numberOfHyperedges;
        if (this.vertexWeights != null) {
            this.vertexWeights = Arrays.copyOf(this.vertexWeights, this.numberOfVertices);
        }
        if (this.hyperedgeWeights != null) {
            this.hyperedgeWeights = Arrays.copyOf(this.hyperedgeWeights, this.numberOfHyperedges);
        }
    }
}

