/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.hypergraph;

import fr.univartois.cril.jkahypar.hypergraph.Hyperedge;
import fr.univartois.cril.jkahypar.hypergraph.WeightedHyperedge;
import java.util.List;

public final class UnweightedHyperedge
implements Hyperedge {
    private final int[] vertices;

    private UnweightedHyperedge(int[] vertices) {
        this.vertices = vertices;
    }

    public static UnweightedHyperedge joining(int ... vertices) {
        return new UnweightedHyperedge(vertices);
    }

    public static UnweightedHyperedge joining(List<Integer> vertices) {
        int[] vertexArray = new int[vertices.size()];
        for (int i = 0; i < vertices.size(); ++i) {
            vertexArray[i] = vertices.get(i);
        }
        return new UnweightedHyperedge(vertexArray);
    }

    @Override
    public int size() {
        return this.vertices.length;
    }

    @Override
    public int[] getVertices() {
        return this.vertices;
    }

    public WeightedHyperedge withWeight(int weight) {
        return new WeightedHyperedge(this, weight);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.size();
        for (int v = 0; v < size; ++v) {
            builder.append(this.vertices[v]);
            if (v == size - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }
}

