/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.hypergraph;

import fr.univartois.cril.jkahypar.hypergraph.AbstractHypergraph;
import fr.univartois.cril.jkahypar.hypergraph.HmetisFormat;
import fr.univartois.cril.jkahypar.hypergraph.Hyperedge;
import fr.univartois.cril.jkahypar.hypergraph.HypergraphBuilder;
import fr.univartois.cril.jkahypar.hypergraph.UnweightedHyperedge;

final class UnweightedHypergraph
extends AbstractHypergraph {
    private final int numberOfVertices;
    private final int numberOfHyperedges;
    private final long[] hyperedgeIndices;
    private final int[] hyperedgeVertices;

    UnweightedHypergraph(HypergraphBuilder builder) {
        super(HmetisFormat.UNWEIGHTED);
        this.numberOfVertices = builder.getNumberOfVertices();
        this.numberOfHyperedges = builder.getNumberOfHyperedges();
        this.hyperedgeIndices = builder.getHyperedgeIndices();
        this.hyperedgeVertices = builder.getHyperedgeVertices();
    }

    @Override
    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public int[] getVertexWeights() {
        return null;
    }

    @Override
    public int getNumberOfHyperedges() {
        return this.numberOfHyperedges;
    }

    @Override
    public Hyperedge getHyperedge(int index) {
        int begin = (int)this.hyperedgeIndices[index];
        int end = (int)this.hyperedgeIndices[index + 1];
        int nbVertices = end - begin;
        int[] vertices = new int[nbVertices];
        for (int i = 0; i < nbVertices; ++i) {
            vertices[i] = this.hyperedgeVertices[begin + i] + 1;
        }
        return UnweightedHyperedge.joining(vertices);
    }

    @Override
    public int[] getHyperedgeWeights() {
        return null;
    }

    @Override
    public long[] getHyperedgeIndices() {
        return this.hyperedgeIndices;
    }

    @Override
    public int[] getHyperedgeVertices() {
        return this.hyperedgeVertices;
    }

    @Override
    public String hmetisHeader() {
        return this.numberOfHyperedges + " " + this.numberOfVertices;
    }
}

