/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.kahypar;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import fr.univartois.cril.jkahypar.hypergraph.Hypergraph;
import fr.univartois.cril.jkahypar.kahypar.INativeKahypar;
import fr.univartois.cril.jkahypar.kahypar.NativeKahyparContext;

public final class NativeKahypar {
    private static final INativeKahypar NATIVE_LIBRARY = (INativeKahypar)Native.load((String)"kahypar", INativeKahypar.class);

    private NativeKahypar() {
        throw new AssertionError((Object)"No NativeKahypar instances for you!");
    }

    public static NativeKahyparContext kahyparContextNew() {
        Pointer context = NATIVE_LIBRARY.kahypar_context_new();
        return new NativeKahyparContext(context);
    }

    static void kahyparConfigureContextFromFile(NativeKahyparContext context, String fileName) {
        NATIVE_LIBRARY.kahypar_configure_context_from_file(context.getNativeContext(), fileName);
    }

    static void kahyparSetCustomTargetBlockWeights(NativeKahyparContext context, int[] blockWeights) {
        NATIVE_LIBRARY.kahypar_set_custom_target_block_weights(blockWeights.length, blockWeights, context.getNativeContext());
    }

    static int kahyparPartition(NativeKahyparContext context, Hypergraph hypergraph, int[] partition) {
        int[] objective = new int[1];
        NATIVE_LIBRARY.kahypar_partition(hypergraph.getNumberOfVertices(), hypergraph.getNumberOfHyperedges(), context.getImbalance(), context.getNumberOfBlocks(), hypergraph.getVertexWeights(), hypergraph.getHyperedgeWeights(), hypergraph.getHyperedgeIndices(), hypergraph.getHyperedgeVertices(), objective, context.getNativeContext(), partition);
        return objective[0];
    }

    static int kahyparImprovePartition(NativeKahyparContext context, Hypergraph hypergraph, int[] initialPartition, long nbIterations, int[] improvedPartition) {
        int[] objective = new int[1];
        NATIVE_LIBRARY.kahypar_improve_partition(hypergraph.getNumberOfVertices(), hypergraph.getNumberOfHyperedges(), context.getImbalance(), context.getNumberOfBlocks(), hypergraph.getVertexWeights(), hypergraph.getHyperedgeWeights(), hypergraph.getHyperedgeIndices(), hypergraph.getHyperedgeVertices(), initialPartition, nbIterations, objective, context.getNativeContext(), improvedPartition);
        return objective[0];
    }

    static void kahyparContextFree(NativeKahyparContext context) {
        NATIVE_LIBRARY.kahypar_context_free(context.getNativeContext());
    }
}

