/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.kahypar;

import com.sun.jna.Pointer;
import fr.univartois.cril.jkahypar.hypergraph.Hypergraph;
import fr.univartois.cril.jkahypar.kahypar.NativeKahypar;
import fr.univartois.cril.jkahypar.kahypar.NativeKahyparPartitioner;

public final class NativeKahyparContext {
    private final Pointer nativeContext;
    private double imbalance;
    private int numberOfBlocks;

    NativeKahyparContext(Pointer nativeContext) {
        this.nativeContext = nativeContext;
    }

    public void configureFrom(String iniFile) {
        NativeKahypar.kahyparConfigureContextFromFile(this, iniFile);
    }

    Pointer getNativeContext() {
        return this.nativeContext;
    }

    public void setImbalance(double imbalance) {
        this.imbalance = imbalance;
    }

    public double getImbalance() {
        return this.imbalance;
    }

    public void setNumberOfBlocks(int numberOfBlocks) {
        this.numberOfBlocks = numberOfBlocks;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public void setBlockWeights(int[] blockWeights) {
        this.setNumberOfBlocks(blockWeights.length);
        NativeKahypar.kahyparSetCustomTargetBlockWeights(this, blockWeights);
    }

    public NativeKahyparPartitioner createPartitionerFor(Hypergraph hypergraph) {
        return new NativeKahyparPartitioner(this, hypergraph);
    }

    public void dispose() {
        NativeKahypar.kahyparContextFree(this);
    }
}

