/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.kahypar;

import fr.univartois.cril.jkahypar.hypergraph.Hypergraph;
import fr.univartois.cril.jkahypar.kahypar.NativeKahypar;
import fr.univartois.cril.jkahypar.kahypar.NativeKahyparContext;

public final class NativeKahyparPartitioner {
    private final NativeKahyparContext context;
    private final Hypergraph hypergraph;
    private int[] lastPartition;
    private int lastObjectiveValue = -1;

    NativeKahyparPartitioner(NativeKahyparContext context, Hypergraph hypergraph) {
        this.context = context;
        this.hypergraph = hypergraph;
    }

    public void computePartition() {
        if (this.lastPartition == null) {
            this.lastPartition = new int[this.hypergraph.getNumberOfVertices()];
            this.lastObjectiveValue = NativeKahypar.kahyparPartition(this.context, this.hypergraph, this.lastPartition);
        }
    }

    public void improvePartition(int nbIterations) {
        int[] newPartition = new int[this.hypergraph.getNumberOfVertices()];
        this.lastObjectiveValue = NativeKahypar.kahyparImprovePartition(this.context, this.hypergraph, this.lastPartition, nbIterations, newPartition);
        this.lastPartition = newPartition;
    }

    public int[] getLastPartition() {
        return this.lastPartition;
    }

    public int getLastObjectiveValue() {
        return this.lastObjectiveValue;
    }
}

