/*
 * Decompiled with CFR 0.152.
 */
package fr.univartois.cril.jkahypar.tools;

import fr.univartois.cril.jkahypar.hypergraph.HmetisFormat;
import fr.univartois.cril.jkahypar.hypergraph.Hypergraph;
import fr.univartois.cril.jkahypar.hypergraph.HypergraphBuilder;
import fr.univartois.cril.jkahypar.hypergraph.UnweightedHyperedge;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

public final class HypergraphParser
implements Closeable {
    private final BufferedReader reader;
    private int numberOfHyperedges;
    private int numberOfVertices;
    private int hmetisFormat;
    private HypergraphBuilder builder;
    private int[] integerLine;

    public HypergraphParser(String inputFile) throws IOException {
        this(Files.newInputStream(Path.of(inputFile, new String[0]), new OpenOption[0]));
    }

    public HypergraphParser(InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.integerLine = new int[3];
    }

    public void parse() throws IOException {
        this.readHypergraphSize();
        this.builder = HypergraphBuilder.createHypergraph(this.numberOfVertices, this.numberOfHyperedges);
        this.integerLine = new int[this.numberOfVertices + 1];
        this.readHyperedges();
        if (this.hasWeightsOnVertices()) {
            this.readVertexWeights();
        }
    }

    private void readHypergraphSize() throws IOException {
        int nb = this.readLine();
        this.numberOfHyperedges = this.integerLine[0];
        this.numberOfVertices = this.integerLine[1];
        if (nb == 3) {
            this.hmetisFormat = this.integerLine[2];
        }
    }

    private void readHyperedges() throws IOException {
        for (int i = 0; i < this.numberOfHyperedges; ++i) {
            this.readHyperedge();
        }
    }

    private void readHyperedge() throws IOException {
        int nb = this.readLine();
        if (this.hasWeightsOnHyperedges()) {
            UnweightedHyperedge hyperedge = UnweightedHyperedge.joining(Arrays.copyOfRange(this.integerLine, 1, nb));
            this.builder.withHyperedge(hyperedge.withWeight(this.integerLine[0]));
        } else {
            UnweightedHyperedge hyperedge = UnweightedHyperedge.joining(Arrays.copyOfRange(this.integerLine, 0, nb));
            this.builder.withHyperedge(hyperedge);
        }
    }

    private void readVertexWeights() throws IOException {
        for (int v = 1; v <= this.numberOfVertices; ++v) {
            this.readLine();
            this.builder.withVertexWeight(v, this.integerLine[0]);
        }
    }

    private boolean hasWeightsOnHyperedges() {
        return HmetisFormat.WEIGHT_ON_HYPEREDGES.isEncodedIn(this.hmetisFormat);
    }

    private boolean hasWeightsOnVertices() {
        return HmetisFormat.WEIGHT_ON_VERTICES.isEncodedIn(this.hmetisFormat);
    }

    private int readLine() throws IOException {
        String line = this.reader.readLine();
        int nb = 0;
        for (String number : line.split("\\s+")) {
            this.integerLine[nb++] = Integer.parseInt(number);
        }
        return nb;
    }

    public Hypergraph getHypergraph() {
        return this.builder.build();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

