/*
 * Decompiled with CFR 0.152.
 */
package fr.diskmth.loggy;

import fr.diskmth.loggy.ANSI;
import fr.diskmth.loggy.Loggable;
import fr.diskmth.loggy.LoggyFile;
import fr.diskmth.loggy.LoggyFormatter;
import fr.diskmth.loggy.LoggyLevel;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Loggy
extends Loggable {
    protected final Logger logger;

    public Loggy(String name, LoggyFormatter formatter) {
        super(formatter);
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The logger name can't be empty or null!");
        }
        this.logger = Logger.getLogger(name);
        this.logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(LoggyFormatter.toJavaFormatter(this.getFormatter()));
        consoleHandler.setLevel(Level.ALL);
        this.logger.addHandler(consoleHandler);
        this.logger.setLevel(Level.ALL);
    }

    public Loggy(String name) {
        this(name, null);
    }

    protected void addLogsFiles(LoggyFile ... files) {
        if (files == null) {
            return;
        }
        for (LoggyFile file : files) {
            if (file == null) continue;
            if (file.getFileHandler() == null) {
                System.out.println(ANSI.format("Impossible to add the log file \"%name%\" because it is not initialized!".replace("%name%", file.getPath().toString()), ANSI.YELLOW));
                return;
            }
            this.logger.addHandler(file.getFileHandler());
        }
    }

    protected void removeLogsFiles(LoggyFile ... files) {
        if (files == null) {
            return;
        }
        for (LoggyFile file : files) {
            if (file == null) continue;
            if (file.getFileHandler() == null) {
                System.out.println(ANSI.format("Impossible to remove the log file \"%name%\" because it is not initialized!".replace("%name%", file.getPath().toString()), ANSI.YELLOW));
                return;
            }
            this.logger.removeHandler(file.getFileHandler());
        }
    }

    protected String buildStackTrace(Throwable thrown) {
        if (thrown == null) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        message.append("    \n").append(thrown).append("\n");
        Arrays.asList(thrown.getStackTrace()).forEach(trace -> message.append("\tat ").append(trace).append("\n"));
        return message.delete(0, 4).delete(message.length() - 1, message.length()).toString();
    }

    public Loggy log(String message, Throwable thrown, LoggyLevel level, LoggyFile ... files) {
        if (!this.isMuted) {
            this.addLogsFiles(files);
            this.logger.log(level.toJavaLevel(), message + this.buildStackTrace(thrown));
            this.removeLogsFiles(files);
        }
        return this;
    }

    public Loggy log(String message, LoggyLevel level, LoggyFile ... files) {
        return this.log(message, null, level, files);
    }

    public Loggy log(Throwable thrown, LoggyLevel level, LoggyFile ... files) {
        return this.log(this.buildStackTrace(thrown), null, level, files);
    }

    public String getName() {
        return this.logger.getName();
    }
}

