/*
 * Decompiled with CFR 0.152.
 */
package fr.diskmth.loggy;

import fr.diskmth.loggy.ANSI;
import fr.diskmth.loggy.LoggyLevel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public abstract class LoggyFormatter {
    public static final LoggyFormatter DEFAULT = new LoggyFormatter(){

        @Override
        public HashMap<LoggyLevel, List<ANSI>> levelsFormat() {
            return new HashMap<LoggyLevel, List<ANSI>>(){
                {
                    this.put(LoggyLevel.FATAL, Arrays.asList(ANSI.multiple(ANSI.BOLD, ANSI.REVERSE, ANSI.RED_BRIGHT), ANSI.RED_BRIGHT));
                    this.put(LoggyLevel.ERROR, Arrays.asList(ANSI.multiple(ANSI.BOLD, ANSI.RED), ANSI.RED));
                    this.put(LoggyLevel.WARN, Arrays.asList(ANSI.multiple(ANSI.BOLD, ANSI.YELLOW), ANSI.YELLOW));
                    this.put(LoggyLevel.INFO, Arrays.asList(ANSI.multiple(ANSI.BOLD, ANSI.GREEN), ANSI.WHITE_BRIGHT));
                    this.put(LoggyLevel.DEBUG, Arrays.asList(ANSI.multiple(ANSI.BOLD, ANSI.CYAN), ANSI.CYAN));
                }
            };
        }

        @Override
        public String format(LoggyLevel level, String loggy, String message) {
            return ANSI.format("[", ANSI.BLUE_BRIGHT) + ANSI.format(loggy, ANSI.MAGENTA) + ANSI.format(" | ", ANSI.BLUE_BRIGHT) + ANSI.format(new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime()), ANSI.WHITE) + ANSI.format(" | ", ANSI.BLUE_BRIGHT) + ANSI.format(level.name(), this.levelsFormat().get((Object)level) != null ? this.levelsFormat().get((Object)level).get(0) : ANSI.WHITE) + ANSI.format("]", ANSI.BLUE_BRIGHT) + ANSI.format(": ", ANSI.WHITE) + ANSI.format(message, this.levelsFormat().get((Object)level) != null ? this.levelsFormat().get((Object)level).get(1) : ANSI.WHITE) + "\n";
        }
    };

    public static Formatter toJavaFormatter(final LoggyFormatter formatter) {
        return new Formatter(){

            @Override
            public String format(LogRecord record) {
                return formatter.format(LoggyLevel.fromJavaLevel(record.getLevel()), record.getLoggerName(), record.getMessage());
            }
        };
    }

    public abstract HashMap<LoggyLevel, List<ANSI>> levelsFormat();

    public abstract String format(LoggyLevel var1, String var2, String var3);

    public LoggyFormatter getFileFormatter() {
        final LoggyFormatter parent = this;
        return new LoggyFormatter(){

            @Override
            public HashMap<LoggyLevel, List<ANSI>> levelsFormat() {
                return parent.levelsFormat();
            }

            @Override
            public String format(LoggyLevel level, String loggy, String message) {
                return ANSI.clearFormat(parent.format(level, loggy, message));
            }
        };
    }
}

