/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fr.dudie.nominatim.client.NominatimClient;
import fr.dudie.nominatim.client.NominatimResponseHandler;
import fr.dudie.nominatim.gson.ArrayOfAddressElementsDeserializer;
import fr.dudie.nominatim.gson.ArrayOfPolygonPointsDeserializer;
import fr.dudie.nominatim.gson.BoundingBoxDeserializer;
import fr.dudie.nominatim.gson.PolygonPointDeserializer;
import fr.dudie.nominatim.model.Address;
import fr.dudie.nominatim.model.AddressElement;
import fr.dudie.nominatim.model.BoundingBox;
import fr.dudie.nominatim.model.PolygonPoint;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonNominatimClient
implements NominatimClient {
    private static final String EMPTY_STRING = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonNominatimClient.class);
    private final Gson gsonInstance;
    private final String searchUrl;
    private final String reverseGeocodingUrlByLonLat;
    private final String reverseGeocodingUrlByLonLatZoom;
    private final String reverseGeocodingUrlByTypeId;
    private final HttpClient httpClient;
    private final NominatimResponseHandler<List<Address>> defaultSearchResponseHandler;
    private final NominatimResponseHandler<Address> defaultReverseGeocodingHandler;

    public JsonNominatimClient(HttpClient httpClient, String email) {
        this("http://nominatim.openstreetmap.org/", httpClient, email, null, false, false);
    }

    public JsonNominatimClient(String baseUrl, HttpClient httpClient, String email, BoundingBox searchBounds, boolean strictBounds, boolean polygon) {
        StringBuilder searchUrlBuilder = new StringBuilder();
        searchUrlBuilder.append(baseUrl);
        searchUrlBuilder.append("/search?format=json&addressdetails=1&q=%s&email=");
        searchUrlBuilder.append(email);
        if (polygon) {
            searchUrlBuilder.append("&polygon=1");
        } else {
            searchUrlBuilder.append("&polygon=0");
        }
        if (searchBounds != null) {
            searchUrlBuilder.append("&viewbox=");
            searchUrlBuilder.append(JsonNominatimClient.toString(searchBounds.getWest())).append(",");
            searchUrlBuilder.append(JsonNominatimClient.toString(searchBounds.getNorth())).append(",");
            searchUrlBuilder.append(JsonNominatimClient.toString(searchBounds.getEast())).append(",");
            searchUrlBuilder.append(JsonNominatimClient.toString(searchBounds.getSouth()));
            if (strictBounds) {
                searchUrlBuilder.append("&bounded=1");
            }
        }
        this.searchUrl = searchUrlBuilder.toString();
        this.reverseGeocodingUrlByLonLat = this.buildReverseGeocodingUrlFor(baseUrl, email, "&lat=%s&lon=%s");
        this.reverseGeocodingUrlByLonLatZoom = this.buildReverseGeocodingUrlFor(baseUrl, email, "&lat=%s&lon=%s&zoom=%s");
        this.reverseGeocodingUrlByTypeId = this.buildReverseGeocodingUrlFor(baseUrl, email, "&osm_type=%s&osm_id=%s");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("API search URL: {}", (Object)this.searchUrl);
            LOGGER.debug("API reverse geocoding URL: {}", (Object)this.reverseGeocodingUrlByLonLat);
            LOGGER.debug("API reverse geocoding URL: {}", (Object)this.reverseGeocodingUrlByLonLatZoom);
            LOGGER.debug("API reverse geocoding URL: {}", (Object)this.reverseGeocodingUrlByTypeId);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(AddressElement[].class, (Object)new ArrayOfAddressElementsDeserializer());
        gsonBuilder.registerTypeAdapter(PolygonPoint.class, (Object)new PolygonPointDeserializer());
        gsonBuilder.registerTypeAdapter(PolygonPoint[].class, (Object)new ArrayOfPolygonPointsDeserializer());
        gsonBuilder.registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxDeserializer());
        this.gsonInstance = gsonBuilder.create();
        this.httpClient = httpClient;
        this.defaultSearchResponseHandler = new NominatimResponseHandler(this.gsonInstance, new TypeToken<List<Address>>(){}.getType());
        this.defaultReverseGeocodingHandler = new NominatimResponseHandler(this.gsonInstance, (Type)((Object)Address.class));
    }

    private String buildReverseGeocodingUrlFor(String baseUrl, String email, String additionalParams) {
        StringBuilder reverseGeocodingUrlBuilder = new StringBuilder();
        reverseGeocodingUrlBuilder.append(baseUrl);
        reverseGeocodingUrlBuilder.append("/reverse?format=json&addressdetails=1&email=");
        reverseGeocodingUrlBuilder.append(email);
        reverseGeocodingUrlBuilder.append(additionalParams);
        return reverseGeocodingUrlBuilder.toString();
    }

    @Override
    public List<Address> search(String query) throws IOException {
        String apiCall = String.format(this.searchUrl, URLEncoder.encode(query, "UTF-8"));
        LOGGER.debug("request url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        List addresses = (List)this.httpClient.execute((HttpUriRequest)req, this.defaultSearchResponseHandler);
        return addresses;
    }

    @Override
    public Address getAddress(double longitude, double latitude) throws IOException {
        String apiCall = String.format(this.reverseGeocodingUrlByLonLat, JsonNominatimClient.toString(latitude), JsonNominatimClient.toString(longitude));
        LOGGER.debug("request url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        Address address = (Address)this.httpClient.execute((HttpUriRequest)req, this.defaultReverseGeocodingHandler);
        return address;
    }

    @Override
    public Address getAddress(double longitude, double latitude, int zoom) throws IOException {
        String apiCall = String.format(this.reverseGeocodingUrlByLonLatZoom, JsonNominatimClient.toString(latitude), JsonNominatimClient.toString(longitude), Integer.toString(zoom));
        LOGGER.debug("request url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        Address address = (Address)this.httpClient.execute((HttpUriRequest)req, this.defaultReverseGeocodingHandler);
        return address;
    }

    @Override
    public Address getAddress(int longitudeE6, int latitudeE6) throws IOException {
        return this.getAddress((double)longitudeE6 / 1000000.0, (double)latitudeE6 / 1000000.0);
    }

    @Override
    public Address getAddress(String type, long id) throws IOException {
        String apiCall = String.format(this.reverseGeocodingUrlByTypeId, type, JsonNominatimClient.toString(id));
        LOGGER.debug("request url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        Address address = (Address)this.httpClient.execute((HttpUriRequest)req, this.defaultReverseGeocodingHandler);
        return address;
    }

    private static String toString(double value) {
        return String.format("%f", value).replaceAll(",", ".");
    }
}

