/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.client;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NominatimResponseHandler<T>
implements ResponseHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NominatimResponseHandler.class);
    private final Gson gsonInstance;
    private final Type responseType;

    public NominatimResponseHandler(Gson gsonInstance, Type responseType) {
        this.gsonInstance = gsonInstance;
        this.responseType = responseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T handleResponse(HttpResponse response) throws IOException {
        Object addresses;
        InputStream content = null;
        try {
            content = response.getEntity().getContent();
            addresses = this.gsonInstance.fromJson((Reader)new InputStreamReader(content, "utf-8"), this.responseType);
        }
        finally {
            if (null != content) {
                content.close();
            }
            response.getEntity().consumeContent();
        }
        return (T)addresses;
    }
}

