/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.client;

import com.github.filosganga.geogson.gson.GeometryAdapterFactory;
import com.github.filosganga.geogson.jts.JtsAdapterFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import fr.dudie.nominatim.client.NominatimClient;
import fr.dudie.nominatim.client.NominatimOptions;
import fr.dudie.nominatim.client.NominatimResponseHandler;
import fr.dudie.nominatim.client.request.NominatimLookupRequest;
import fr.dudie.nominatim.client.request.NominatimReverseRequest;
import fr.dudie.nominatim.client.request.NominatimSearchRequest;
import fr.dudie.nominatim.client.request.paramhelper.OsmType;
import fr.dudie.nominatim.gson.ArrayOfAddressElementsDeserializer;
import fr.dudie.nominatim.gson.ArrayOfPolygonPointsDeserializer;
import fr.dudie.nominatim.gson.BoundingBoxDeserializer;
import fr.dudie.nominatim.gson.PolygonPointDeserializer;
import fr.dudie.nominatim.model.Address;
import fr.dudie.nominatim.model.BoundingBox;
import fr.dudie.nominatim.model.Element;
import fr.dudie.nominatim.model.PolygonPoint;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonNominatimClient
implements NominatimClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonNominatimClient.class);
    private static final String DEFAULT_BASE_URL = "http://nominatim.openstreetmap.org/";
    public static final String ENCODING_UTF_8 = "UTF-8";
    private final Gson gsonInstance;
    private final String searchUrl;
    private final String reverseUrl;
    private final String lookupUrl;
    private final NominatimOptions defaults;
    private HttpClient httpClient;
    private NominatimResponseHandler<List<Address>> defaultSearchResponseHandler;
    private NominatimResponseHandler<Address> defaultReverseGeocodingHandler;
    private NominatimResponseHandler<List<Address>> defaultLookupHandler;

    public JsonNominatimClient(HttpClient httpClient, String email) {
        this(DEFAULT_BASE_URL, httpClient, email, new NominatimOptions());
    }

    public JsonNominatimClient(HttpClient httpClient, String email, NominatimOptions defaults) {
        this(DEFAULT_BASE_URL, httpClient, email, defaults);
    }

    public JsonNominatimClient(String baseUrl, HttpClient httpClient, String email) {
        this(baseUrl, httpClient, email, new NominatimOptions());
    }

    public JsonNominatimClient(String baseUrl, HttpClient httpClient, String email, NominatimOptions defaults) {
        String emailEncoded;
        try {
            emailEncoded = URLEncoder.encode(email, ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            emailEncoded = email;
        }
        this.searchUrl = String.format("%s/search?format=jsonv2&email=%s", baseUrl.replaceAll("/$", ""), emailEncoded);
        this.reverseUrl = String.format("%s/reverse?format=json&email=%s", baseUrl.replaceAll("/$", ""), emailEncoded);
        this.lookupUrl = String.format("%s/lookup?format=json&email=%s", baseUrl.replaceAll("/$", ""), emailEncoded);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("API search URL: {}", (Object)this.searchUrl);
            LOGGER.debug("API reverse URL: {}", (Object)this.reverseUrl);
        }
        this.defaults = defaults;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Element[].class, (Object)new ArrayOfAddressElementsDeserializer());
        gsonBuilder.registerTypeAdapter(PolygonPoint.class, (Object)new PolygonPointDeserializer());
        gsonBuilder.registerTypeAdapter(PolygonPoint[].class, (Object)new ArrayOfPolygonPointsDeserializer());
        gsonBuilder.registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxDeserializer());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new JtsAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GeometryAdapterFactory());
        this.gsonInstance = gsonBuilder.create();
        this.httpClient = httpClient;
        this.defaultSearchResponseHandler = new NominatimResponseHandler(this.gsonInstance, new TypeToken<List<Address>>(){}.getType());
        this.defaultReverseGeocodingHandler = new NominatimResponseHandler(this.gsonInstance, (Type)((Object)Address.class));
        this.defaultLookupHandler = new NominatimResponseHandler(this.gsonInstance, new TypeToken<List<Address>>(){}.getType());
    }

    @Override
    public List<Address> search(NominatimSearchRequest search) throws IOException {
        String apiCall = String.format("%s&%s", this.searchUrl, search.getQueryString());
        LOGGER.debug("search url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        return (List)this.httpClient.execute((HttpUriRequest)req, this.defaultSearchResponseHandler);
    }

    @Override
    public Address getAddress(NominatimReverseRequest reverse) throws IOException {
        String apiCall = String.format("%s&%s", this.reverseUrl, reverse.getQueryString());
        LOGGER.debug("reverse geocoding url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        return (Address)this.httpClient.execute((HttpUriRequest)req, this.defaultReverseGeocodingHandler);
    }

    @Override
    public List<Address> lookupAddress(NominatimLookupRequest lookup) throws IOException {
        String apiCall = String.format("%s&%s", this.lookupUrl, lookup.getQueryString());
        LOGGER.debug("lookup url: {}", (Object)apiCall);
        HttpGet req = new HttpGet(apiCall);
        return (List)this.httpClient.execute((HttpUriRequest)req, this.defaultLookupHandler);
    }

    @Override
    public List<Address> search(String query) throws IOException {
        NominatimSearchRequest q = new NominatimSearchRequest();
        this.defaults.mergeTo(q);
        q.setQuery(query);
        return this.search(q);
    }

    @Override
    public Address getAddress(double longitude, double latitude) throws IOException {
        NominatimReverseRequest q = new NominatimReverseRequest();
        q.setQuery(longitude, latitude);
        return this.getAddress(q);
    }

    @Override
    public Address getAddress(double longitude, double latitude, int zoom) throws IOException {
        NominatimReverseRequest q = new NominatimReverseRequest();
        q.setQuery(longitude, latitude);
        q.setZoom(zoom);
        return this.getAddress(q);
    }

    @Override
    public Address getAddress(int longitudeE6, int latitudeE6) throws IOException {
        return this.getAddress((double)longitudeE6 / 1000000.0, (double)latitudeE6 / 1000000.0);
    }

    @Override
    public Address getAddress(String type, long id) throws IOException {
        NominatimReverseRequest q = new NominatimReverseRequest();
        q.setQuery(OsmType.from(type), id);
        return this.getAddress(q);
    }

    @Override
    public List<Address> lookupAddress(List<String> typeId) throws IOException {
        NominatimLookupRequest q = new NominatimLookupRequest();
        q.setQuery(typeId);
        return this.lookupAddress(q);
    }
}

