/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.client.request;

import fr.dudie.nominatim.client.request.NominatimRequest;
import fr.dudie.nominatim.client.request.SearchQuery;
import fr.dudie.nominatim.client.request.SimpleSearchQuery;
import fr.dudie.nominatim.client.request.paramhelper.BooleanSerializer;
import fr.dudie.nominatim.client.request.paramhelper.BoundingBoxSerializer;
import fr.dudie.nominatim.client.request.paramhelper.ListSerializer;
import fr.dudie.nominatim.client.request.paramhelper.PolygonFormat;
import fr.dudie.nominatim.client.request.paramhelper.QueryParameter;
import fr.dudie.nominatim.model.BoundingBox;
import java.util.ArrayList;
import java.util.List;

public class NominatimSearchRequest
extends NominatimRequest {
    @QueryParameter(encode=false)
    private SearchQuery query;
    @QueryParameter(value="accept-language=%s")
    private String acceptLanguage;
    @QueryParameter(value="countrycodes=%s", serializer=ListSerializer.class)
    private List<String> countryCodes;
    @QueryParameter(value="viewbox=%s", serializer=BoundingBoxSerializer.class)
    private BoundingBox viewBox;
    @QueryParameter(value="bounded=%s", serializer=BooleanSerializer.class)
    private Boolean bounded;
    @QueryParameter(value="addressdetails=%s", serializer=BooleanSerializer.class)
    private Boolean address;
    @QueryParameter(value="namedetails=%s", serializer=BooleanSerializer.class)
    private Boolean name;
    @QueryParameter(value="exclude_place_ids=%s", serializer=ListSerializer.class)
    private List<String> excludePlaceIds;
    @QueryParameter(value="limit=%s")
    private Integer limit;
    @QueryParameter(encode=false)
    private PolygonFormat polygonFormat;

    public SearchQuery getQuery() {
        return this.query;
    }

    public void setQuery(SearchQuery query) {
        this.query = query;
    }

    public void setQuery(String simpleQuery) {
        this.query = new SimpleSearchQuery(simpleQuery);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<String> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public void addCountryCode(String countryCode) {
        if (null == this.countryCodes) {
            this.countryCodes = new ArrayList<String>();
        }
        this.countryCodes.add(countryCode);
    }

    public BoundingBox getViewBox() {
        return this.viewBox;
    }

    public void setViewBox(BoundingBox viewBox) {
        this.viewBox = viewBox;
    }

    public void setViewBox(double west, double north, double east, double south) {
        this.viewBox = new BoundingBox();
        this.viewBox.setWest(west);
        this.viewBox.setNorth(north);
        this.viewBox.setEast(east);
        this.viewBox.setSouth(south);
    }

    public void setViewBox(int westE6, int northE6, int eastE6, int southE6) {
        this.viewBox = new BoundingBox();
        this.viewBox.setWestE6(westE6);
        this.viewBox.setNorthE6(northE6);
        this.viewBox.setEastE6(eastE6);
        this.viewBox.setSouthE6(southE6);
    }

    public Boolean getBounded() {
        return this.bounded;
    }

    public void setBounded(boolean bounded) {
        this.bounded = bounded;
    }

    public boolean getAddress() {
        return this.address;
    }

    public void setAddress(boolean address) {
        this.address = address;
    }

    public Boolean getName() {
        return this.name;
    }

    public void setName(Boolean name) {
        this.name = name;
    }

    public List<String> getExcludePlaceIds() {
        return this.excludePlaceIds;
    }

    public void setExcludePlaceIds(List<String> excludePlaceIds) {
        this.excludePlaceIds = excludePlaceIds;
    }

    public void addExcludedlaceId(String placeId) {
        if (null == this.countryCodes) {
            this.excludePlaceIds = new ArrayList<String>();
        }
        this.excludePlaceIds.add(placeId);
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public PolygonFormat getPolygonFormat() {
        return this.polygonFormat;
    }

    public void setPolygonFormat(PolygonFormat polygonFormat) {
        this.polygonFormat = polygonFormat;
    }
}

