/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver;

import fr.dysp.semver.Semver;
import fr.dysp.semver.SemverParser;
import fr.dysp.semver.exceptions.InvalidFormatException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeSemverParser
implements SemverParser {
    private final List<SemverParser> parsers;

    public CompositeSemverParser(SemverParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public boolean accepts(String text) {
        for (SemverParser parser : this.parsers) {
            if (!parser.accepts(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Semver parse(String text) throws InvalidFormatException {
        for (SemverParser parser : this.parsers) {
            if (!parser.accepts(text)) continue;
            return parser.parse(text);
        }
        throw new InvalidFormatException(String.format("No parser accepted version '%s': %s", text, this.parsers.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ", "[", "]"))));
    }
}

