/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Semver
implements Comparable<Semver> {
    private static final Predicate<String> NUMERIC_FRAGMENT_PREDICATE = Pattern.compile("\\d+").asMatchPredicate();
    public static final String DOT = ".";
    private final int major;
    private final int minor;
    private final int patch;
    private final List<String> snapshotParts;
    private final List<String> metadataParts;

    public Semver(Integer major, Integer minor, Integer patch, List<String> snapshotParts, List<String> metadataParts) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.snapshotParts = Objects.requireNonNullElse(snapshotParts, Collections.emptyList());
        this.metadataParts = Objects.requireNonNullElse(metadataParts, Collections.emptyList());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public List<String> getSnapshotParts() {
        return this.snapshotParts;
    }

    public List<String> getMetadataParts() {
        return this.metadataParts;
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(this.major).append(DOT).append(this.minor).append(DOT).append(this.patch);
        if (!this.snapshotParts.isEmpty()) {
            repr.append("-").append(String.join((CharSequence)DOT, this.snapshotParts));
        }
        if (!this.metadataParts.isEmpty()) {
            repr.append("+").append(String.join((CharSequence)DOT, this.metadataParts));
        }
        return repr.toString();
    }

    @Override
    public int compareTo(Semver o) {
        if (!Objects.equals(this.major, o.major)) {
            return Integer.compare(this.major, o.major);
        }
        if (!Objects.equals(this.minor, o.minor)) {
            return Integer.compare(this.minor, o.minor);
        }
        if (!Objects.equals(this.patch, o.patch)) {
            return Integer.compare(this.patch, o.patch);
        }
        if (this.snapshotParts.isEmpty() && !o.snapshotParts.isEmpty()) {
            return 1;
        }
        if (!this.snapshotParts.isEmpty() && o.snapshotParts.isEmpty()) {
            return -1;
        }
        return this.compareSnapshotParts(o);
    }

    protected int compareSnapshotParts(Semver o) {
        int comparablePartCount = Math.min(this.snapshotParts.size(), o.snapshotParts.size());
        for (int i = 0; i < comparablePartCount; ++i) {
            String theirs;
            if (i >= this.snapshotParts.size()) {
                return -1;
            }
            if (i >= o.snapshotParts.size()) {
                return 1;
            }
            String ours = this.snapshotParts.get(i);
            int partComparison = this.singlePartComparison(ours, theirs = o.snapshotParts.get(i));
            if (partComparison == 0) continue;
            return partComparison;
        }
        return 0;
    }

    private int singlePartComparison(String ours, String theirs) {
        boolean numericOurs = NUMERIC_FRAGMENT_PREDICATE.test(ours);
        boolean numericTheirs = NUMERIC_FRAGMENT_PREDICATE.test(theirs);
        if (numericOurs) {
            if (!numericTheirs) {
                return -1;
            }
            int ourValue = Integer.parseUnsignedInt(ours);
            int theirValue = Integer.parseUnsignedInt(theirs);
            return ourValue - theirValue;
        }
        if (numericTheirs) {
            return 1;
        }
        return ours.compareTo(theirs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Semver)) {
            return false;
        }
        return Objects.equals(this.toString(), obj.toString());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.major).append(this.minor).append(this.patch).append(this.snapshotParts).append(this.metadataParts).toHashCode();
    }
}

