/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver;

import fr.dysp.semver.Semver;
import fr.dysp.semver.exceptions.InvalidFormatException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface SemverParser {
    public static final String NUMERIC_IDENTIFIER_PATTERN_FRAGMENT = "0|[1-9]\\d*";
    public static final String PRERELEASE_IDENTIFIER_PATTERN_FRAGMENT = "(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*)";
    public static final String BUILD_METADATA_IDENTIFIER_PATTERN_FRAGMENT = "[0-9a-z-]+";
    public static final String PRERELEASE_PATTERN_GROUP = "(?<prerelease>(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*)(?:\\.(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*))*+)";
    public static final String BUILD_METADATA_PATTERN_GROUP = "(?<buildmetadata>[0-9a-z-]+(?:\\.[0-9a-z-]+)*+)";
    public static final Pattern SPECIFICATION_PATTERN = Pattern.compile("(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<prerelease>(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*)(?:\\.(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*))*+))?(?:\\+(?<buildmetadata>[0-9a-z-]+(?:\\.[0-9a-z-]+)*+))?", 2);

    default public boolean accepts(String text) {
        return SPECIFICATION_PATTERN.asMatchPredicate().test(text);
    }

    public Semver parse(String var1) throws InvalidFormatException;

    default public List<String> parseCompositeIdentifier(String composite) {
        return Optional.ofNullable(composite).map(s -> s.split("\\.")).stream().flatMap(Arrays::stream).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static enum MatchGroups {
        MAJOR("major"),
        MINOR("minor"),
        PATCH("patch"),
        PRERELEASE("prerelease"),
        BUILDMETADATA("buildmetadata");

        final String repr;

        private MatchGroups(String repr) {
            this.repr = repr;
        }

        public String getRepr() {
            return this.repr;
        }
    }
}

