/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver;

import fr.dysp.semver.Semver;
import fr.dysp.semver.SemverParser;
import fr.dysp.semver.exceptions.InvalidFormatException;
import java.util.List;
import java.util.regex.Matcher;

public class StrictSemverParser
implements SemverParser {
    @Override
    public Semver parse(String text) throws InvalidFormatException {
        Matcher matcher = SPECIFICATION_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new InvalidFormatException(text);
        }
        int major = Integer.parseUnsignedInt(matcher.group(SemverParser.MatchGroups.MAJOR.getRepr()));
        int minor = Integer.parseUnsignedInt(matcher.group(SemverParser.MatchGroups.MINOR.getRepr()));
        int patch = Integer.parseUnsignedInt(matcher.group(SemverParser.MatchGroups.PATCH.getRepr()));
        List<String> snapshotParts = this.parseCompositeIdentifier(matcher.group(SemverParser.MatchGroups.PRERELEASE.getRepr()));
        List<String> metadataParts = this.parseCompositeIdentifier(matcher.group(SemverParser.MatchGroups.BUILDMETADATA.getRepr()));
        return new Semver(major, minor, patch, snapshotParts, metadataParts);
    }
}

