/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver.extensions.loose;

import fr.dysp.semver.Semver;
import java.util.List;
import java.util.Objects;

public class LooseSemver
extends Semver {
    private final boolean hasMinor;
    private final boolean hasPatch;

    public LooseSemver(int major, Integer minor, Integer patch, List<String> snapshotParts, List<String> metadataParts) {
        super(major, Objects.requireNonNullElse(minor, 0), Objects.requireNonNullElse(patch, 0), snapshotParts, metadataParts);
        this.hasMinor = Objects.nonNull(minor);
        this.hasPatch = Objects.nonNull(patch);
    }

    @Override
    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(this.getMajor());
        if (this.hasMinor) {
            repr.append(".").append(this.getMinor());
        }
        if (this.hasPatch) {
            repr.append(".").append(this.getPatch());
        }
        if (!this.getSnapshotParts().isEmpty()) {
            repr.append("-").append(String.join((CharSequence)".", this.getSnapshotParts()));
        }
        if (!this.getMetadataParts().isEmpty()) {
            repr.append("+").append(String.join((CharSequence)".", this.getMetadataParts()));
        }
        return repr.toString();
    }
}

