/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver.extensions.loose;

import fr.dysp.semver.Semver;
import fr.dysp.semver.SemverParser;
import fr.dysp.semver.exceptions.InvalidFormatException;
import fr.dysp.semver.extensions.loose.LooseSemver;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LooseSemverParser
implements SemverParser {
    private static final Pattern LOOSE_PATTERN = Pattern.compile("(?<major>0|[1-9]\\d*)(?:\\.(?<minor>0|[1-9]\\d*)(?:\\.(?<patch>0|[1-9]\\d*))?)?(?:-(?<prerelease>(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*)(?:\\.(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*))*+))?(?:\\+(?<buildmetadata>[0-9a-z-]+(?:\\.[0-9a-z-]+)*+))?", 2);

    @Override
    public boolean accepts(String text) {
        return LOOSE_PATTERN.asMatchPredicate().test(text);
    }

    @Override
    public Semver parse(String text) throws InvalidFormatException {
        Matcher matcher = LOOSE_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new InvalidFormatException(text);
        }
        int major = Integer.parseUnsignedInt(matcher.group(SemverParser.MatchGroups.MAJOR.getRepr()));
        Integer minor = Optional.ofNullable(matcher.group(SemverParser.MatchGroups.MINOR.getRepr())).map(Integer::parseUnsignedInt).orElse(null);
        Integer patch = Optional.ofNullable(matcher.group(SemverParser.MatchGroups.PATCH.getRepr())).map(Integer::parseUnsignedInt).orElse(null);
        List<String> snapshotParts = this.parseCompositeIdentifier(matcher.group(SemverParser.MatchGroups.PRERELEASE.getRepr()));
        List<String> metadataParts = this.parseCompositeIdentifier(matcher.group(SemverParser.MatchGroups.BUILDMETADATA.getRepr()));
        return new LooseSemver(major, minor, patch, snapshotParts, metadataParts);
    }
}

