/*
 * Decompiled with CFR 0.152.
 */
package fr.dysp.semver.extensions.textual;

import fr.dysp.semver.Semver;
import fr.dysp.semver.SemverParser;
import fr.dysp.semver.exceptions.InvalidFormatException;
import fr.dysp.semver.extensions.textual.TextualSemver;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextualSemverParser
implements SemverParser {
    private static final Pattern TEXT_PATTERN = Pattern.compile("(?<prerelease>(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*)(?:\\.(?:[0-9a-z-]*[a-z-][0-9a-z-]*|0|[1-9]\\d*))*+)(?:\\+(?<buildmetadata>[0-9a-z-]+(?:\\.[0-9a-z-]+)*+))?", 2);

    @Override
    public boolean accepts(String text) {
        return TEXT_PATTERN.asMatchPredicate().test(text);
    }

    @Override
    public Semver parse(String text) throws InvalidFormatException {
        Matcher matcher = TEXT_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new InvalidFormatException(text);
        }
        List<String> snapshotParts = this.parseCompositeIdentifier(matcher.group(SemverParser.MatchGroups.PRERELEASE.getRepr()));
        List<String> metadataParts = this.parseCompositeIdentifier(matcher.group(SemverParser.MatchGroups.BUILDMETADATA.getRepr()));
        return new TextualSemver(snapshotParts, metadataParts);
    }
}

