/*
 * Decompiled with CFR 0.152.
 */
package fr.faylixe.marklet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import fr.faylixe.marklet.MarkletConstant;
import fr.faylixe.marklet.MarkletDocumentBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class ClassPageBuilder
extends MarkletDocumentBuilder {
    private static final String HIERARCHY_SEPARATOR = " > ";
    private final ClassDoc classDoc;

    private ClassPageBuilder(ClassDoc classDoc) {
        super(classDoc.containingPackage());
        this.classDoc = classDoc;
    }

    private boolean hasMethod() {
        return this.classDoc.methods().length > 0;
    }

    private boolean hasField() {
        return this.classDoc.fields().length > 0;
    }

    private boolean hasConstructor() {
        return this.classDoc.constructors().length > 0;
    }

    private boolean isNotInherited(MethodDoc methodDoc) {
        return methodDoc.overriddenMethod() == null;
    }

    private void classHierarchy() {
        ArrayList<ClassDoc> hierarchy = new ArrayList<ClassDoc>();
        for (ClassDoc current = this.classDoc; current != null; current = current.superclass()) {
            hierarchy.add(current);
        }
        for (int i = hierarchy.size() - 1; i >= 0; --i) {
            this.classLink(this.getSource(), (ClassDoc)hierarchy.get(i));
            if (i <= 0) continue;
            this.text(HIERARCHY_SEPARATOR);
        }
    }

    private void interfaceHierarchy() {
        HashSet<Type> implementedInterfaces = new HashSet<Type>();
        for (ClassDoc current = this.classDoc; current != null; current = current.superclass()) {
            implementedInterfaces.addAll(Arrays.asList(current.interfaceTypes()));
        }
        if (!implementedInterfaces.isEmpty()) {
            this.text("All implemented interfaces :");
            this.newLine();
            this.item();
            int limit = implementedInterfaces.size() - 1;
            Type[] types = implementedInterfaces.toArray(new Type[implementedInterfaces.size()]);
            for (int i = 0; i < types.length; ++i) {
                this.typeLink(this.getSource(), types[i]);
                if (i >= limit) continue;
                this.character(',');
                this.character(' ');
            }
        }
    }

    private void title() {
        this.header(1);
        StringBuilder builder = new StringBuilder();
        if (this.classDoc.isInterface()) {
            builder.append("Interface");
        } else if (this.classDoc.isEnum()) {
            builder.append("Enumeration");
        } else if (this.classDoc.isAnnotationType()) {
            builder.append("Annotation");
        } else {
            builder.append("Class");
        }
        builder.append(' ').append(this.classDoc.name());
        this.text(builder.toString());
    }

    private void header() {
        this.title();
        this.newLine();
        this.newLine();
        PackageDoc packageDoc = this.classDoc.containingPackage();
        String packageName = packageDoc.name();
        this.item();
        this.text("Package");
        this.character(' ');
        this.link(packageName, "README.html");
        this.newLine();
        this.item();
        this.classHierarchy();
        this.interfaceHierarchy();
        this.newLine();
        this.newLine();
        this.description((Doc)this.classDoc);
        this.newLine();
        this.newLine();
    }

    private <T extends Doc> Stream<T> getOrderedElements(Supplier<T[]> supplier) {
        return Arrays.stream(supplier.get()).sorted((a, b) -> a.name().compareTo(b.name()));
    }

    private void methodsSummary() {
        if (this.hasMethod()) {
            this.header(4);
            this.text("Methods");
            this.newLine();
            this.tableHeader(MarkletConstant.METHODS_SUMMARY_HEADERS);
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).methods()).filter(this::isNotInherited).forEach(this::rowSignature);
            this.newLine();
        }
    }

    public void inheritedMethodSummary() {
        for (ClassDoc current = this.classDoc.superclass(); current != null; current = current.superclass()) {
            this.header(5);
            this.text("Inherited method from ");
            this.classLink(this.getSource(), current);
            this.newLine();
            for (MethodDoc methodDoc : current.methods()) {
                this.link(methodDoc.flatSignature(), "");
            }
        }
    }

    private void fieldsSummary() {
        if (this.hasField()) {
            this.header(4);
            this.text("Fields");
            this.newLine();
            this.tableHeader(MarkletConstant.FIELDS_SUMMARY_HEADERS);
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).fields()).filter(ProgramElementDoc::isStatic).forEach(this::rowSignature);
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).fields()).filter(field -> !field.isStatic()).forEach(this::rowSignature);
            this.newLine();
        }
    }

    private void constructorsSummary() {
        if (this.hasConstructor()) {
            this.header(4);
            this.text("Constructors");
            this.newLine();
            this.tableHeader(MarkletConstant.CONSTRUCTOR_SUMMARY_HEADERS);
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).constructors()).forEach(this::rowSignature);
            this.newLine();
        }
    }

    private void summary() {
        if (this.hasField() || this.hasMethod() || this.hasConstructor()) {
            this.newLine();
            this.header(2);
            this.text("Summary");
            this.newLine();
            this.fieldsSummary();
            this.constructorsSummary();
            this.methodsSummary();
            this.newLine();
        }
    }

    private void constructors() {
        if (this.hasConstructor()) {
            this.newLine();
            this.header(1);
            this.text("Constructors");
            this.newLine();
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).constructors()).forEach(this::member);
        }
    }

    private void fields() {
        if (this.hasField()) {
            this.newLine();
            this.header(1);
            this.text("Fields");
            this.newLine();
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).fields()).filter(field -> !field.isStatic()).forEach(this::field);
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).fields()).filter(ProgramElementDoc::isStatic).forEach(this::field);
        }
    }

    private void methods() {
        if (this.hasMethod()) {
            this.newLine();
            this.header(1);
            this.text("Methods");
            this.newLine();
            this.getOrderedElements(() -> ((ClassDoc)this.classDoc).methods()).filter(this::isNotInherited).forEach(this::member);
        }
    }

    public static void build(ClassDoc classDoc, Path directoryPath) throws IOException {
        Path classPath = Paths.get(new StringBuffer().append(classDoc.simpleTypeName()).append(".html.md").toString(), new String[0]);
        ClassPageBuilder builder = new ClassPageBuilder(classDoc);
        builder.header();
        builder.summary();
        builder.constructors();
        builder.fields();
        builder.methods();
        builder.build(directoryPath.resolve(classPath));
    }
}

