/*
 * Decompiled with CFR 0.152.
 */
package fr.faylixe.marklet;

public class MarkdownDocumentBuilder {
    public static final String LINK_EXTENSION = ".html";
    public static final String FILE_EXTENSION = ".html.md";
    private static final String BOLD = "**";
    private static final String CODE = "`";
    private static final String ITALIC = "*";
    private static final String LIST_ITEM = "* ";
    private static final String QUOTE = "> ";
    private static final String BR = "<br>";
    private static final String HR = "---";
    private static final String ROW_START = "| ";
    private static final String CELL_SEPARATOR = " | ";
    private static final String ROW_END = " |";
    private static final String LINK_OPEN = "<a href=";
    private static final String LINK_CLOSE = "</a>";
    private static final String PARAGRAPH_OPEN = "<p>";
    private static final String PARAGRAPH_CLOSE = "</p>";
    private final StringBuffer buffer = new StringBuffer();

    private final String filterParagraph(String text) {
        return text.replaceAll(PARAGRAPH_OPEN, "").replaceAll(PARAGRAPH_CLOSE, "");
    }

    public final void newLine() {
        this.buffer.append("\n");
    }

    public final void text(String text) {
        this.buffer.append(this.filterParagraph(text));
    }

    public final void character(char character) {
        this.buffer.append(character);
    }

    public final void bold(String text) {
        this.buffer.append(BOLD).append(text).append(BOLD);
    }

    public final void code(String text) {
        this.buffer.append(CODE).append(text).append(CODE);
    }

    public final void italic(String text) {
        this.buffer.append(ITALIC).append(text).append(ITALIC);
    }

    public final void quote() {
        this.buffer.append(QUOTE);
    }

    public final void item() {
        this.buffer.append(LIST_ITEM);
    }

    public final void horizontalRule() {
        this.buffer.append(HR);
        this.newLine();
    }

    public final void breakingReturn() {
        this.buffer.append(BR);
        this.newLine();
    }

    public final void header(int level) {
        for (int i = 0; i < level; ++i) {
            this.buffer.append('#');
        }
        this.buffer.append(' ');
    }

    public final void rawLink(String label, String url) {
        this.buffer.append(LINK_OPEN).append('\"').append(url).append('\"').append('>').append(label).append(LINK_CLOSE);
    }

    public final void link(String label, String url) {
        this.buffer.append('[').append(label).append(']').append('(').append(url).append(')');
    }

    public final void startTableRow() {
        this.buffer.append(ROW_START);
    }

    public final void cell() {
        this.buffer.append(CELL_SEPARATOR);
    }

    public final void endTableRow() {
        this.buffer.append(ROW_END);
    }

    public final void tableHeader(String ... headers) {
        this.tableRow(headers);
        this.startTableRow();
        for (int i = 0; i < headers.length; ++i) {
            this.buffer.append(HR);
            if (i >= headers.length - 1) continue;
            this.cell();
        }
        this.endTableRow();
        this.newLine();
    }

    public final void tableRow(String ... cells) {
        this.startTableRow();
        for (int i = 0; i < cells.length; ++i) {
            this.buffer.append(cells[i]);
            if (i >= cells.length - 1) continue;
            this.cell();
        }
        this.endTableRow();
        this.newLine();
    }

    public final String build() {
        return this.buffer.toString();
    }
}

