/*
 * Decompiled with CFR 0.152.
 */
package fr.faylixe.marklet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import fr.faylixe.marklet.ClassPageBuilder;
import fr.faylixe.marklet.MarkletOptions;
import fr.faylixe.marklet.PackagePageBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public final class Marklet {
    private final MarkletOptions options;
    private final RootDoc root;

    private Marklet(MarkletOptions options, RootDoc root) {
        this.root = root;
        this.options = options;
    }

    private Path getPackageDirectory(String packageName) {
        String directory = packageName.replace('.', '/');
        String path = this.options.getOutputDirectory() + directory;
        return Paths.get(path, new String[0]);
    }

    private Path generatePackage(PackageDoc packageDoc) throws IOException {
        String name = packageDoc.name();
        this.root.printNotice("Generates package documentation for " + name);
        if (!name.isEmpty()) {
            Path directoryPath = this.getPackageDirectory(name);
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            PackagePageBuilder.build(packageDoc, directoryPath);
            return directoryPath;
        }
        return Paths.get(".", new String[0]);
    }

    private void buildPackages() throws IOException {
        HashSet<PackageDoc> packages = new HashSet<PackageDoc>();
        for (ClassDoc classDoc : this.root.classes()) {
            PackageDoc packageDoc = classDoc.containingPackage();
            if (packages.contains(packageDoc)) continue;
            packages.add(packageDoc);
            this.generatePackage(packageDoc);
        }
    }

    private void buildClasses() throws IOException {
        for (ClassDoc classDoc : this.root.classes()) {
            PackageDoc packageDoc = classDoc.containingPackage();
            String packageName = packageDoc.name();
            Path packageDirectory = this.getPackageDirectory(packageName);
            this.root.printNotice("Generates documentation for " + classDoc.name());
            ClassPageBuilder.build(classDoc, packageDirectory);
        }
    }

    private boolean start() {
        try {
            Path outputDirectory = Paths.get(this.options.getOutputDirectory(), new String[0]);
            System.out.println("Target output directory : " + outputDirectory.toAbsolutePath().toString());
            if (!Files.exists(outputDirectory, new LinkOption[0])) {
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            this.buildPackages();
            this.buildClasses();
        }
        catch (IOException e) {
            this.root.printError(e.getMessage());
            return false;
        }
        return true;
    }

    public static int optionLength(String option) {
        return MarkletOptions.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return MarkletOptions.validOptions(options, reporter);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static boolean start(RootDoc root) {
        MarkletOptions options = MarkletOptions.parse(root.options());
        Marklet marklet = new Marklet(options, root);
        boolean result = false;
        try {
            result = marklet.start();
        }
        catch (Exception e) {
            root.printError("An exception has been caught during generation (see stack trace below).");
            e.printStackTrace();
        }
        return result;
    }
}

