/*
 * Decompiled with CFR 0.152.
 */
package fr.faylixe.marklet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import fr.faylixe.marklet.MarkdownDocumentBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang3.StringUtils;

public class MarkletDocumentBuilder
extends MarkdownDocumentBuilder {
    private static final String RETURN_TAG = "return";
    private static final String UP_DIRECTORY = "../";
    private static final String PARAMETER_DETAIL_SEPARATOR = ": ";
    private final PackageDoc source;

    public MarkletDocumentBuilder(PackageDoc source) {
        this.source = source;
    }

    public final PackageDoc getSource() {
        return this.source;
    }

    public void classLink(PackageDoc source, ClassDoc target) {
        if (target.isIncluded()) {
            String path = MarkletDocumentBuilder.getPath(source.name(), target.containingPackage().name());
            StringBuffer urlBuilder = new StringBuffer();
            urlBuilder.append(path).append(target.simpleTypeName()).append(".html");
            this.link(target.simpleTypeName(), urlBuilder.toString());
        } else {
            this.italic(target.qualifiedName());
        }
    }

    public void typeLink(PackageDoc source, Type type) {
        if (type.isPrimitive()) {
            this.code(type.simpleTypeName());
        } else {
            ClassDoc classDoc = type.asClassDoc();
            this.classLink(source, classDoc);
            this.parameterLinks(source, type);
        }
    }

    private void parameterLinks(PackageDoc source, Type type) {
        Type[] types;
        ParameterizedType invocation = type.asParameterizedType();
        if (invocation != null && (types = invocation.typeArguments()).length > 0) {
            this.character('<');
            for (int i = 0; i < types.length; ++i) {
                this.parameterLink(source, types[i]);
                if (i >= types.length - 1) continue;
                this.text(", ");
            }
            this.character('>');
        }
    }

    private void parameterLink(PackageDoc source, Type type) {
        WildcardType wildcard = type.asWildcardType();
        if (wildcard != null) {
            this.character('?');
        } else {
            TypeVariable variableType = type.asTypeVariable();
            if (variableType != null) {
                Type[] bounds = variableType.bounds();
                if (bounds.length > 0) {
                    this.text("? extends ");
                    for (int i = 0; i < bounds.length; ++i) {
                        this.typeLink(source, bounds[i]);
                        if (i >= bounds.length - 1) continue;
                        this.text(" & ");
                    }
                }
            } else {
                this.typeLink(source, type);
            }
        }
    }

    public void methodLink(PackageDoc source, MethodDoc method) {
    }

    public void description(Doc doc) {
        this.description(doc.inlineTags());
    }

    public void description(Tag[] inlineTags) {
        for (Tag tag : inlineTags) {
            if ("Text".equals(tag.name())) {
                this.text(tag.text());
                continue;
            }
            if (!"@link".equals(tag.name())) continue;
            SeeTag seeTag = (SeeTag)tag;
            ClassDoc classDoc = seeTag.referencedClass();
            if (classDoc != null) {
                this.classLink(this.source, classDoc);
                continue;
            }
            this.text(tag.text());
        }
    }

    public void returnSignature(ProgramElementDoc element) {
        this.code(element.modifiers());
        if (element.isMethod()) {
            MethodDoc method = (MethodDoc)element;
            this.character(' ');
            this.typeLink(method.containingPackage(), method.returnType());
        }
    }

    public void linkedName(ProgramElementDoc element) {
        StringBuffer anchorBuilder = new StringBuffer().append('#').append(element.name());
        if (element instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc member = (ExecutableMemberDoc)element;
            Parameter[] parameters = member.parameters();
            if (parameters.length == 0) {
                // empty if block
            }
            for (int i = 0; i < parameters.length; ++i) {
                anchorBuilder.append(parameters[i].type().simpleTypeName());
                if (i >= parameters.length - 1) continue;
                anchorBuilder.append('-');
            }
        }
        String url = anchorBuilder.toString().toLowerCase();
        this.link(element.name(), url);
    }

    private void inlineParameters(Parameter[] parameters) {
        this.character('(');
        for (int i = 0; i < parameters.length; ++i) {
            this.typeLink(this.source, parameters[i].type());
            this.character(' ');
            this.text(parameters[i].name());
            if (i >= parameters.length - 1) continue;
            this.character(',');
            this.character(' ');
        }
        this.character(')');
    }

    private void headerSignature(ExecutableMemberDoc member) {
        this.header(2);
        this.text(member.name());
        this.text(member.flatSignature());
    }

    public void rowSignature(ProgramElementDoc element) {
        this.startTableRow();
        this.returnSignature(element);
        this.cell();
        this.linkedName(element);
        if (element instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc member = (ExecutableMemberDoc)element;
            this.inlineParameters(member.parameters());
        }
        this.endTableRow();
        this.newLine();
    }

    public void itemSignature(ProgramElementDoc element) {
        this.item();
        this.returnSignature(element);
        this.character(' ');
        this.linkedName(element);
        if (element instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc member = (ExecutableMemberDoc)element;
            this.inlineParameters(member.parameters());
        }
        this.newLine();
    }

    public void field(FieldDoc fieldDoc) {
        this.header(2);
        this.text(fieldDoc.name());
        this.newLine();
        this.code(fieldDoc.modifiers());
        this.character(' ');
        this.typeLink(this.source, fieldDoc.type());
        this.newLine();
        this.newLine();
        this.description((Doc)fieldDoc);
        this.newLine();
        this.newLine();
        this.newLine();
    }

    public void member(ExecutableMemberDoc member) {
        this.headerSignature(member);
        this.newLine();
        this.description((Doc)member);
        this.newLine();
        this.newLine();
        this.parameters(member.paramTags());
        if (member.isMethod()) {
            MethodDoc methodDoc = (MethodDoc)member;
            this.returnType(methodDoc.tags(RETURN_TAG));
        }
        this.exceptions(member.throwsTags());
        this.newLine();
        this.newLine();
    }

    private void parameters(ParamTag[] parameters) {
        if (parameters.length > 0) {
            this.header(3);
            this.bold("Parameters");
            this.newLine();
            for (ParamTag parameter : parameters) {
                this.item();
                this.code(parameter.parameterName());
                this.text(PARAMETER_DETAIL_SEPARATOR);
                this.description(parameter.inlineTags());
                this.newLine();
            }
            this.newLine();
        }
    }

    private void returnType(Tag[] tag) {
        if (tag.length > 0) {
            this.header(3);
            this.bold("Returns");
            this.newLine();
            this.description(tag[0].inlineTags());
            this.newLine();
            this.newLine();
        }
    }

    private void exceptions(ThrowsTag[] exceptions) {
        if (exceptions.length > 0) {
            this.header(3);
            this.bold("Throws");
            this.newLine();
            for (ThrowsTag exception : exceptions) {
                this.item();
                this.classLink(this.source, exception.exception());
                this.character(' ');
                this.description(exception.inlineTags());
                this.newLine();
            }
            this.newLine();
        }
    }

    public void build(Path path) throws IOException {
        this.newLine();
        this.text("[![Marklet](https://img.shields.io/badge/Generated%20by-Marklet-green.svg)](https://github.com/Faylixe/marklet)");
        String content = super.build();
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
    }

    public static String getPath(String source, String target) {
        if (source.equals(target)) {
            return "";
        }
        StringBuffer pathBuilder = new StringBuffer();
        String common = StringUtils.getCommonPrefix((String[])new String[]{source, target});
        int start = common.length();
        boolean endsWithDot = common.endsWith(".");
        if (!common.equals(source)) {
            if (endsWithDot) {
                pathBuilder.append(UP_DIRECTORY);
            }
            String back = source.substring(start);
            for (int i = 0; i < StringUtils.countMatches((CharSequence)back, (char)'.'); ++i) {
                pathBuilder.append(UP_DIRECTORY);
            }
        }
        if (!common.equals(target)) {
            String forward = target.substring(endsWithDot ? start : start + 1);
            pathBuilder.append(forward.replace('.', '/'));
            pathBuilder.append('/');
        }
        return pathBuilder.toString();
    }
}

