/*
 * Decompiled with CFR 0.152.
 */
package fr.faylixe.marklet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import fr.faylixe.marklet.MarkletDocumentBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Supplier;

public final class PackagePageBuilder
extends MarkletDocumentBuilder {
    private final PackageDoc packageDoc;

    private PackagePageBuilder(PackageDoc packageDoc) {
        super(packageDoc);
        this.packageDoc = packageDoc;
    }

    private void header() {
        this.header(1);
        this.text("Package");
        this.character(' ');
        this.text(this.packageDoc.name());
        this.newLine();
        this.description((Doc)this.packageDoc);
        this.newLine();
    }

    private void classIndex(String label, Supplier<ClassDoc[]> classSupplier) {
        ClassDoc[] classDocs = classSupplier.get();
        if (classDocs.length > 0) {
            this.header(2);
            this.text(label);
            this.newLine();
            this.tableHeader("Name", "Description");
            Arrays.stream(classDocs).forEach(this::classRow);
            this.newLine();
        }
    }

    private void classRow(ClassDoc classDoc) {
        this.startTableRow();
        this.classLink(this.packageDoc, classDoc);
        this.cell();
        this.text(classDoc.commentText().replaceAll("\\n", " ").replaceFirst("\\..*", "."));
        this.endTableRow();
        this.newLine();
    }

    private void indexes() {
        this.classIndex("Annotations", () -> ((PackageDoc)this.packageDoc).annotationTypes());
        this.classIndex("Enumerations", () -> ((PackageDoc)this.packageDoc).enums());
        this.classIndex("Interfaces", () -> ((PackageDoc)this.packageDoc).interfaces());
        this.classIndex("Classes", () -> ((PackageDoc)this.packageDoc).allClasses());
    }

    public static void build(PackageDoc packageDoc, Path directoryPath) throws IOException {
        PackagePageBuilder packageBuilder = new PackagePageBuilder(packageDoc);
        packageBuilder.header();
        packageBuilder.indexes();
        Path path = directoryPath.resolve("README.html.md");
        packageBuilder.build(path);
    }
}

