/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowzipper;

import fr.flowarg.flowio.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class ZipUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompressTarArchive(Path tarGzFile, Path destinationDir) throws IOException {
        try (InputStream is = Files.newInputStream(tarGzFile, new OpenOption[0]);
             GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(is);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                OutputStream fos;
                block48: {
                    Path path = destinationDir.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(path, new FileAttribute[0]);
                        continue;
                    }
                    byte[] data = new byte[8192];
                    fos = Files.newOutputStream(path, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        int count;
                        while ((count = tarIn.read(data, 0, 4096)) != -1) {
                            fos.write(data, 0, count);
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    public static void gzipFile(Path baseFile, Path newFile) throws IOException {
        byte[] buffer = new byte[4096];
        if (baseFile != null && newFile != null) {
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(Files.newOutputStream(newFile, new OpenOption[0]));
                 InputStream fileInputStream = Files.newInputStream(baseFile, new OpenOption[0]);){
                int bytesRead;
                while ((bytesRead = fileInputStream.read(buffer)) > 0) {
                    gzipOutputStream.write(buffer, 0, bytesRead);
                }
                gzipOutputStream.finish();
            }
        }
    }

    public static void compressDirectory(Path directory, Path destZipFile) throws IOException {
        ZipUtils.compressFiles(FileUtils.list(directory), destZipFile);
    }

    public static void compressFiles(List<Path> listFiles, Path destZipFile) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(destZipFile, new OpenOption[0]));){
            for (Path file : listFiles) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    ZipUtils.addFolderToZip(file, file.getFileName().toString(), zos);
                    continue;
                }
                ZipUtils.addFileToZip(file, zos);
            }
            zos.flush();
        }
    }

    private static void addFolderToZip(Path folder, String parentFolder, ZipOutputStream zos) throws IOException {
        for (Path path : FileUtils.list(folder)) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                ZipUtils.addFolderToZip(path, parentFolder + '/' + path.getFileName().toString(), zos);
                return;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + path.getFileName().toString()));
            InputStream bis = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                int read;
                byte[] buffer = new byte[4096];
                while ((read = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, read);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bis == null) continue;
                if (throwable != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bis.close();
            }
        }
    }

    private static void addFileToZip(Path file, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(file.getFileName().toString()));
        try (InputStream bis = Files.newInputStream(file, new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, read);
            }
        }
    }

    public static void unzip(Path destinationDir, Path zipFile) throws IOException {
        try (ZipFile toUnZip = new ZipFile(zipFile.toFile());){
            Enumeration<? extends ZipEntry> enu = toUnZip.entries();
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                ZipUtils.unzip0(destinationDir.resolve(entry.getName()), toUnZip, entry);
            }
        }
    }

    private static void unzip0(Path fl, ZipFile zipFile, ZipEntry entry) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        if (Files.notExists(fl, new LinkOption[0])) {
            Files.createDirectories(fl.getParent(), new FileAttribute[0]);
        }
        Files.copy(zipFile.getInputStream(entry), fl, new CopyOption[0]);
    }

    public static void unzipJar(Path destinationDir, Path jarPath, String ... args) throws IOException {
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> enu = jar.entries();
            while (enu.hasMoreElements()) {
                JarEntry je = enu.nextElement();
                Path fl = destinationDir.resolve(je.getName());
                if (args.length >= 1 && args[0] != null && args[0].equals("ignoreMetaInf") && fl.toString().contains("META-INF")) continue;
                ZipUtils.unzip0(fl, jar, je);
            }
        }
    }
}

