/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowcompat;

public final class Platform {
    public static final String OS = System.getProperty("os.name", "").toLowerCase();

    public static void exit(int exitCode, boolean halt) {
        if (halt) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            System.exit(exitCode);
        }
    }

    public static boolean isOn(EnumOS platform) {
        for (String alias : platform.getNames()) {
            if (!OS.contains(alias)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnMac() {
        return Platform.isOn(EnumOS.MAC);
    }

    public static boolean isOnWindows() {
        return Platform.isOn(EnumOS.WINDOWS);
    }

    public static boolean isOnLinux() {
        return Platform.isOn(EnumOS.LINUX);
    }

    public static EnumOS getCurrentPlatform() {
        for (EnumOS en : EnumOS.values()) {
            for (int i = 0; i < en.getNames().length; ++i) {
                if (!en.getNames()[i].equalsIgnoreCase(OS)) continue;
                return en;
            }
            for (String s : en.getNames()) {
                if (!OS.contains(s)) continue;
                return en;
            }
        }
        return null;
    }

    public static String getArch() {
        return System.getProperty("sun.arch.data.model");
    }

    public static enum EnumOS {
        MAC("mac", "osx", "macos", "darwin"),
        WINDOWS("windows", "win"),
        LINUX("linux", "unix");

        private final String[] names;

        private EnumOS(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }
    }
}

