/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowlogger;

import fr.flowarg.flowlogger.ILogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger
implements ILogger {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("hh:mm:ss");
    private final String prefix;
    private Path logPath;
    private PrintWriter writer;

    public Logger(String prefix, Path logPath, boolean append) {
        String string = this.prefix = prefix.endsWith(" ") ? prefix : prefix + " ";
        if (logPath == null) {
            return;
        }
        this.logPath = logPath.toAbsolutePath();
        try {
            if (Files.notExists(this.logPath, new LinkOption[0])) {
                Files.createDirectories(this.logPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.logPath, new FileAttribute[0]);
            }
            this.writer = append ? new PrintWriter(Files.newBufferedWriter(this.logPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND)) : new PrintWriter(Files.newBufferedWriter(this.logPath, StandardCharsets.UTF_8, new OpenOption[0]));
            Runtime.getRuntime().addShutdownHook(new Thread(this.writer::close));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Logger(String prefix, Path logFile) {
        this(prefix, logFile, false);
    }

    public void message(boolean err, String toWrite) {
        String date = String.format("[%s] ", SIMPLE_DATE_FORMAT.format(new Date()));
        String msg = date + this.prefix + (err ? "[ERROR]: " : "[INFO]: ") + toWrite;
        if (err) {
            System.out.println((Object)((Object)ILogger.EnumLogColor.RED) + msg + (Object)((Object)ILogger.EnumLogColor.RESET));
        } else {
            System.out.println(msg);
        }
        this.writeToTheLogFile(msg);
    }

    @Override
    public void infoColor(ILogger.EnumLogColor color, String toWrite) {
        String date = String.format("[%s] ", SIMPLE_DATE_FORMAT.format(new Date()));
        String msg = date + this.prefix + "[INFO]: " + toWrite;
        String coloredMessage = (Object)((Object)color) + msg + (Object)((Object)ILogger.EnumLogColor.RESET);
        System.out.println(coloredMessage);
        this.writeToTheLogFile(msg);
    }

    @Override
    public void info(String message) {
        this.message(false, message);
    }

    @Override
    public void err(String message) {
        this.message(true, message);
    }

    @Override
    public void warn(String message) {
        String date = String.format("[%s] ", SIMPLE_DATE_FORMAT.format(new Date()));
        String msg = date + this.prefix + "[WARN]: " + message;
        String coloredWarn = (Object)((Object)ILogger.EnumLogColor.YELLOW) + msg + (Object)((Object)ILogger.EnumLogColor.RESET);
        System.out.println(coloredWarn);
        this.writeToTheLogFile(msg);
    }

    @Override
    public void debug(String message) {
        String date = String.format("[%s] ", SIMPLE_DATE_FORMAT.format(new Date()));
        String msg = date + this.prefix + "[DEBUG]: " + message;
        String coloredMessage = (Object)((Object)ILogger.EnumLogColor.CYAN) + msg + (Object)((Object)ILogger.EnumLogColor.RESET);
        System.out.println(coloredMessage);
        this.writeToTheLogFile(msg);
    }

    @Override
    public void writeToTheLogFile(String toLog) {
        if (this.logPath == null) {
            return;
        }
        try {
            if (Files.notExists(this.logPath, new LinkOption[0])) {
                Files.createDirectories(this.logPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.logPath, new FileAttribute[0]);
            }
            if (this.writer != null) {
                this.writer.println(toLog);
                this.writer.flush();
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
        }
    }

    @Override
    public void printStackTrace(Throwable error) {
        this.printStackTrace0(error, 0);
    }

    private void printStackTrace0(Throwable error, int n) {
        if (n > 10) {
            System.out.println((Object)((Object)ILogger.EnumLogColor.RED) + "..." + (Object)((Object)ILogger.EnumLogColor.RESET));
            return;
        }
        if (n == 0) {
            this.err(error.toString());
        } else {
            String toPrint = "Caused by: ";
            System.out.println((Object)((Object)ILogger.EnumLogColor.RED) + "Caused by: " + error.toString() + (Object)((Object)ILogger.EnumLogColor.RESET));
            this.writeToTheLogFile("Caused by: ");
        }
        for (StackTraceElement trace : error.getStackTrace()) {
            String toPrint = "\tat " + trace.toString();
            System.out.println((Object)((Object)ILogger.EnumLogColor.RED) + toPrint + (Object)((Object)ILogger.EnumLogColor.RESET));
            this.writeToTheLogFile(toPrint);
        }
        if (error.getCause() != null) {
            this.printStackTrace0(error.getCause(), n + 1);
        }
    }

    @Override
    @Deprecated
    public void printStackTrace(String errorName, Throwable error) {
        this.printStackTrace(error);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public Path getLogPath() {
        return this.logPath;
    }

    @Override
    public void setLogPath(Path logPath) {
        this.logPath = logPath;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }
}

