/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.openlauncherlib;

import fr.theshark34.openlauncherlib.configuration.api.json.JSONReader;
import fr.theshark34.openlauncherlib.external.ExternalLaunchProfile;
import fr.theshark34.openlauncherlib.external.ExternalLauncher;
import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.GameFolder;
import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoFramework {
    private final Map<String, Function<Parameters, String>> keyValue = new HashMap<String, Function<Parameters, String>>();
    private final Path gameDir;
    private final Path libraries;
    private final String clientJar;
    private List<String> additionalVmArgs;
    private List<String> additionalArgs;
    private String customVanillaJsonFileName = "";
    private String customForgeJsonFileName = "";
    private String serverName = "";
    private SafeConsumer<ExternalLauncher> lastCallback;

    public NoFramework(Path gameDir, AuthInfos infos, GameFolder folder) {
        this(gameDir, infos, folder, new ArrayList<String>(), new ArrayList<String>());
    }

    public NoFramework(Path gameDir, AuthInfos infos, GameFolder folder, List<String> additionalArgs, Type type) {
        this(gameDir, infos, folder, (List<String>)(type == Type.VM ? additionalArgs : new ArrayList()), type == Type.GAME ? additionalArgs : new ArrayList());
    }

    public NoFramework(Path gameDir, AuthInfos infos, GameFolder folder, List<String> additionalVmArgs, List<String> additionalArgs) {
        this.gameDir = gameDir;
        this.libraries = this.gameDir.resolve(folder.getLibsFolder());
        this.clientJar = folder.getMainJar();
        this.additionalVmArgs = additionalVmArgs;
        this.additionalArgs = additionalArgs;
        this.keyValue.put("${library_directory}", parameters -> this.libraries.toAbsolutePath().toString());
        this.keyValue.put("${classpath_separator}", parameters -> File.pathSeparator);
        this.keyValue.put("${auth_player_name}", parameters -> infos.getUsername());
        this.keyValue.put("${version_name}", parameters -> ((Parameters)parameters).processing.getString("id"));
        this.keyValue.put("${game_directory}", parameters -> this.gameDir.toAbsolutePath().toString());
        this.keyValue.put("${assets_root}", parameters -> this.gameDir.resolve(folder.getAssetsFolder()).toAbsolutePath().toString());
        this.keyValue.put("${assets_index_name}", parameters -> ((Parameters)parameters).vanilla.getJSONObject("assetIndex").getString("id"));
        this.keyValue.put("${auth_uuid}", parameters -> infos.getUuid());
        this.keyValue.put("${auth_access_token}", parameters -> infos.getAccessToken());
        this.keyValue.put("${user_type}", parameters -> "msa");
        this.keyValue.put("${version_type}", parameters -> "release");
        this.keyValue.put("${clientid}", parameters -> infos.getClientId());
        this.keyValue.put("${auth_xuid}", parameters -> infos.getAuthXUID());
        this.keyValue.put("${natives_directory}", parameters -> this.gameDir.resolve(folder.getNativesFolder()).toAbsolutePath().toString());
    }

    public Process launch(String version, String forgeVersion) throws Exception {
        Logger logger = Logger.getLogger("OpenLauncherLib");
        Path vanillaJson = this.customVanillaJsonFileName.equals("") ? this.gameDir.resolve(version + ".json") : this.gameDir.resolve(this.customVanillaJsonFileName);
        JSONObject vanilla = new JSONReader(logger, vanillaJson).toJSONObject();
        Path forgeJson = this.customForgeJsonFileName.equals("") ? this.gameDir.resolve(version + "-forge-" + forgeVersion + ".json") : this.gameDir.resolve(this.customForgeJsonFileName);
        JSONObject forge = new JSONReader(logger, forgeJson).toJSONObject();
        LogUtil.info("no-framework");
        ExternalLauncher launcher = new ExternalLauncher(new ExternalLaunchProfile(forge.getString("mainClass"), this.getClassPath(vanilla, forge), this.getVmArgs(vanilla, forge), this.getArgs(vanilla, forge), true, this.serverName.equals("") ? "Minecraft " + version : this.serverName, this.gameDir));
        if (this.lastCallback != null) {
            this.lastCallback.accept(launcher);
        }
        return launcher.launch();
    }

    private List<String> getVmArgs(JSONObject vanilla, JSONObject forge) {
        ArrayList<String> result = new ArrayList<String>(this.getVmArgsFor(vanilla, vanilla));
        result.addAll(this.getVmArgsFor(forge, vanilla));
        result.addAll(this.additionalVmArgs);
        return result;
    }

    private List<String> getVmArgsFor(JSONObject object, JSONObject vanilla) {
        Parameters parameters = new Parameters();
        parameters.vanilla = vanilla;
        parameters.processing = object;
        ArrayList<String> sb = new ArrayList<String>();
        JSONArray array = object.getJSONObject("arguments").getJSONArray("jvm");
        for (Object element : array) {
            String arg;
            if (!(element instanceof String) || (arg = (String)element).contains("minecraft.launcher") || arg.contains("${classpath}") || arg.equals("-cp")) continue;
            sb.add(this.map(arg, parameters));
        }
        return sb;
    }

    private String getClassPath(JSONObject vanilla, JSONObject forge) {
        ArrayList<String> cp = new ArrayList<String>();
        this.appendLibraries(cp, forge);
        this.appendLibraries(cp, vanilla);
        cp.add(this.gameDir.toAbsolutePath().resolve("client.jar").toString());
        return this.toString(cp);
    }

    private void appendLibraries(List<String> sb, JSONObject object) {
        object.getJSONArray("libraries").forEach(jsonElement -> {
            Path path = this.libraries.resolve(((JSONObject)jsonElement).getJSONObject("downloads").getJSONObject("artifact").getString("path"));
            String str = path.toAbsolutePath() + File.pathSeparator;
            if (!sb.contains(str) && Files.exists(path, new LinkOption[0])) {
                sb.add(str);
            }
        });
    }

    private List<String> getArgs(JSONObject vanilla, JSONObject forge) {
        Parameters parameters = new Parameters();
        parameters.vanilla = vanilla;
        parameters.processing = forge;
        ArrayList<String> result = new ArrayList<String>(this.getArgs(vanilla, parameters));
        result.addAll(this.getArgs(forge, parameters));
        result.addAll(this.additionalArgs);
        return result;
    }

    private List<String> getArgs(JSONObject object, Parameters parameters) {
        JSONArray array = object.getJSONObject("arguments").getJSONArray("game");
        ArrayList<String> sb = new ArrayList<String>();
        for (Object element : array) {
            if (!(element instanceof String)) continue;
            sb.add(this.map((String)element, parameters));
        }
        return sb;
    }

    private String map(String str, Parameters parameters) {
        if (str.contains("${version_name}.jar")) {
            return str.replace("${version_name}.jar", this.clientJar);
        }
        String result = str;
        for (Map.Entry<String, Function<Parameters, String>> entry : this.keyValue.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue().apply(parameters));
        }
        return result;
    }

    private String toString(List<String> stringList) {
        StringBuilder sb = new StringBuilder();
        stringList.forEach(sb::append);
        return sb.toString();
    }

    public List<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    public List<String> getAdditionalVmArgs() {
        return this.additionalVmArgs;
    }

    public String getCustomVanillaJsonFileName() {
        return this.customVanillaJsonFileName;
    }

    public String getCustomForgeJsonFileName() {
        return this.customForgeJsonFileName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public SafeConsumer<ExternalLauncher> getLastCallback() {
        return this.lastCallback;
    }

    public void setAdditionalArgs(List<String> additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    public void setAdditionalVmArgs(List<String> additionalVmArgs) {
        this.additionalVmArgs = additionalVmArgs;
    }

    public void setCustomVanillaJsonFileName(String customVanillaJsonFileName) {
        this.customVanillaJsonFileName = customVanillaJsonFileName;
    }

    public void setCustomForgeJsonFileName(String customForgeJsonFileName) {
        this.customForgeJsonFileName = customForgeJsonFileName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setLastCallback(SafeConsumer<ExternalLauncher> lastCallback) {
        this.lastCallback = lastCallback;
    }

    public static interface SafeConsumer<T> {
        public void accept(T var1) throws Exception;

        default public SafeConsumer<T> andThen(SafeConsumer<? super T> after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }

    public static enum Type {
        VM,
        GAME;

    }

    private static class Parameters {
        private JSONObject vanilla;
        private JSONObject processing;

        private Parameters() {
        }
    }
}

