/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.configuration.api.json;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.json.JSONArray;
import org.json.JSONObject;

@ModifiedByFlow
public final class JSONWriter
implements Closeable {
    private final BufferedWriter writer;
    private int space;

    public JSONWriter(String path) throws IOException {
        this(Paths.get(path, new String[0]));
    }

    public JSONWriter(Path file) throws IOException {
        this(Files.newBufferedWriter(file, new OpenOption[0]));
    }

    public JSONWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    public void write(JSONArray array) throws IOException {
        this.writer.write("[");
        this.writer.newLine();
        this.space += 2;
        String space = this.spaceBuilder();
        for (int i = 0; i < array.length(); ++i) {
            Object object = array.get(i);
            if (object instanceof Number || object instanceof Boolean) {
                this.writer.write(space + object);
            } else if (object instanceof JSONObject) {
                this.write((JSONObject)object, true);
            } else if (object instanceof JSONArray) {
                this.write((JSONArray)object);
            } else {
                this.writer.write(space + "\"" + object.toString() + "\"");
            }
            if (i < array.length() - 1) {
                this.writer.write(",");
            }
            this.writer.newLine();
        }
        this.space -= 2;
        space = this.spaceBuilder();
        this.writer.write(space + "]");
    }

    private void write(JSONObject jsonObject, boolean spacing) throws IOException {
        this.writer.write((spacing ? this.spaceBuilder() : "") + "{");
        this.writer.newLine();
        this.space += 2;
        String space = this.spaceBuilder();
        int i = 0;
        int max = jsonObject.length();
        for (String key : jsonObject.keySet()) {
            this.writer.write(space + "\"" + key + "\":");
            Object object = jsonObject.get(key);
            if (object instanceof Number || object instanceof Boolean) {
                this.writer.write(object.toString());
            } else if (object instanceof JSONObject) {
                this.write((JSONObject)object, false);
            } else if (object instanceof JSONArray) {
                this.write((JSONArray)object);
            } else {
                this.writer.write("\"" + object.toString() + "\"");
            }
            if (i < max - 1) {
                this.writer.write(",");
            }
            ++i;
            this.writer.newLine();
        }
        this.space -= 2;
        space = this.spaceBuilder();
        this.writer.write(space + "}");
    }

    public void write(JSONObject jsonObject) throws IOException {
        this.write(jsonObject, false);
    }

    private String spaceBuilder() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.space; ++i) {
            builder.append(" ");
        }
        return builder.length() == 0 ? "" : builder.toString();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

