/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.minecraft.GameType;
import fr.theshark34.openlauncherlib.minecraft.GameVersion;
import fr.theshark34.openlauncherlib.minecraft.util.GameDirGenerator;
import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;

@ModifiedByFlow
public class GameInfos {
    private final String serverName;
    private final Path gameDir;
    private GameTweak[] tweaks;
    private final GameVersion gameVersion;

    public GameInfos(String serverName, GameVersion gameVersion, GameTweak[] tweaks) {
        this(serverName, GameDirGenerator.createGameDir(serverName, true), gameVersion, tweaks);
    }

    public GameInfos(String serverName, boolean inLinuxLocalShare, GameVersion gameVersion, GameTweak[] tweaks) {
        this(serverName, GameDirGenerator.createGameDir(serverName, inLinuxLocalShare), gameVersion, tweaks);
    }

    @Deprecated
    public GameInfos(String serverName, File gameDir, GameVersion gameVersion, GameTweak[] tweaks) {
        this(serverName, gameDir.toPath(), gameVersion, tweaks);
    }

    public GameInfos(String serverName, Path gameDir, GameVersion gameVersion, GameTweak[] tweaks) {
        this.serverName = serverName;
        this.gameDir = gameDir;
        this.gameVersion = gameVersion;
        this.tweaks = tweaks;
        if (tweaks == null) {
            return;
        }
        boolean forge = false;
        boolean shaderOrOptifine = false;
        if (gameVersion.getGameType().equals(GameType.V1_13_HIGHER_FORGE)) {
            if (tweaks.length == 1 && tweaks[0] == GameTweak.FORGE) {
                tweaks = new GameTweak[]{};
            } else if (tweaks.length != 0) {
                LogUtil.info("tweak-deprec");
            }
        }
        for (GameTweak tweak : tweaks) {
            if (tweak.equals(GameTweak.FORGE)) {
                if (gameVersion.getGameType().equals(GameType.V1_5_2_LOWER)) {
                    LogUtil.info("forge-old");
                }
                forge = true;
                continue;
            }
            if (tweak != GameTweak.OPTIFINE && tweak != GameTweak.SHADER) continue;
            shaderOrOptifine = true;
        }
        if (forge || gameVersion.getGameType().equals(GameType.V1_13_HIGHER_FORGE)) {
            LogUtil.info("support-forge");
        }
        if (tweaks.length > 0 && gameVersion.getGameType().equals(GameType.V1_5_2_LOWER)) {
            LogUtil.info("old-tweaking");
        }
        if (shaderOrOptifine && forge) {
            LogUtil.info("forge-optifine");
            ArrayList<GameTweak> tweakList = new ArrayList<GameTweak>();
            for (GameTweak tweak : tweaks) {
                if (tweak == GameTweak.OPTIFINE || tweak == GameTweak.SHADER) continue;
                tweakList.add(tweak);
            }
            this.tweaks = tweakList.toArray(new GameTweak[0]);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public Path getGameDir() {
        return this.gameDir;
    }

    public GameVersion getGameVersion() {
        return this.gameVersion;
    }

    public GameTweak[] getGameTweaks() {
        return this.tweaks;
    }

    public boolean hasGameTweak(GameTweak tweak) {
        for (GameTweak gameTweak : this.tweaks) {
            if (!gameTweak.equals(tweak)) continue;
            return true;
        }
        return false;
    }
}

