/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;

@ModifiedByFlow
public class CrashReporter {
    private Path dir;
    private String name;

    @Deprecated
    public CrashReporter(String name, File dir) {
        this(name, dir.toPath());
    }

    public CrashReporter(String name, Path dir) {
        this.name = name;
        this.dir = dir;
    }

    public void catchError(Exception e, String message) {
        String msg;
        LogUtil.err("ex-caught");
        System.out.printf("%s\n", CrashReporter.makeCrashReport(this.name, e));
        try {
            msg = "\nThe crash report is in : " + this.writeError(e).toString() + "";
        }
        catch (IOException e2) {
            LogUtil.err("report-error");
            e.printStackTrace();
            msg = "\nAnd unable to write the crash report :( : " + e2;
        }
        JOptionPane.showMessageDialog(null, message + "\n" + e + "\n" + msg, "Error", 0);
        System.exit(1);
    }

    public Path writeError(Exception e) throws IOException {
        Path path;
        int number = 0;
        while (Files.exists(path = this.dir.resolve("crash-" + number + ".txt"), new LinkOption[0])) {
            ++number;
        }
        LogUtil.info("writing-crash", path.toString());
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(CrashReporter.makeCrashReport(this.name, e));
        }
        return path;
    }

    public Path getDir() {
        return this.dir;
    }

    public void setDir(Path dir) {
        this.dir = dir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String makeCrashReport(String projectName, Exception e) {
        StackTraceElement[] causeStackTrace;
        StackTraceElement[] stackTrace;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        StringBuilder report = new StringBuilder().append("# ").append(projectName).append(" Crash Report\n\r").append("#\n\r# At : ").append(dateFormat.format(date)).append("\n\r").append("#\n\r# Exception : ").append(e.getClass().getSimpleName()).append("\n\r").append("\n\r# ").append(e);
        for (StackTraceElement element : stackTrace = e.getStackTrace()) {
            report.append("\n\r#     ").append(element);
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return report.toString();
        }
        report.append("\n\r# Caused by: ").append(cause);
        for (StackTraceElement element : causeStackTrace = cause.getStackTrace()) {
            report.append("\n\r#     ").append(element);
        }
        return report.toString();
    }
}

