/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util.explorer;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ModifiedByFlow
public class FileList {
    protected List<Path> files;

    public FileList() {
        this.files = new ArrayList<Path>();
    }

    public FileList(List<Path> files) {
        this.files = files;
    }

    public void add(Path ... files) {
        this.add(Arrays.asList(files));
    }

    public void add(List<Path> files) {
        this.files.addAll(files);
    }

    public void add(FileList list) {
        this.add(list.get());
    }

    public FileList match(String regex) {
        ArrayList<Path> matching = new ArrayList<Path>();
        for (Path f : this.files) {
            if (!f.toString().matches(regex)) continue;
            matching.add(f);
        }
        return new FileList(matching);
    }

    public FileList dirs() {
        ArrayList<Path> dirs = new ArrayList<Path>();
        for (Path f : this.files) {
            if (!Files.isDirectory(f, new LinkOption[0])) continue;
            dirs.add(f);
        }
        return new FileList(dirs);
    }

    public FileList files() {
        ArrayList<Path> files = new ArrayList<Path>();
        for (Path f : this.files) {
            if (Files.isDirectory(f, new LinkOption[0])) continue;
            files.add(f);
        }
        return new FileList(files);
    }

    public List<Path> get() {
        return this.files;
    }
}

