/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.external;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.JavaUtil;
import fr.theshark34.openlauncherlib.LaunchException;
import fr.theshark34.openlauncherlib.external.BeforeLaunchingEvent;
import fr.theshark34.openlauncherlib.external.ExternalLaunchProfile;
import fr.theshark34.openlauncherlib.util.LogUtil;
import fr.theshark34.openlauncherlib.util.ProcessLogManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExternalLauncher {
    private BeforeLaunchingEvent launchingEvent;
    private ExternalLaunchProfile profile;
    private boolean logsEnabled = true;
    @ModifiedByFlow
    private List<String> vmArgs = new ArrayList<String>();

    public ExternalLauncher(ExternalLaunchProfile profile) {
        this(profile, null);
    }

    public ExternalLauncher(ExternalLaunchProfile profile, BeforeLaunchingEvent launchingEvent) {
        this.profile = profile;
        this.launchingEvent = launchingEvent;
    }

    public boolean isLogsEnabled() {
        return this.logsEnabled;
    }

    public void setLogsEnabled(boolean logsEnabled) {
        this.logsEnabled = logsEnabled;
    }

    @ModifiedByFlow
    public Process launch() throws LaunchException {
        LogUtil.info("hi-ext");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        this.vmArgs.add(JavaUtil.getJavaCommand());
        if (this.profile.getMacDockName() != null && System.getProperty("os.name").toLowerCase().contains("mac")) {
            this.vmArgs.add(JavaUtil.macDockName(this.profile.getMacDockName()));
        }
        if (this.profile.getVmArgs() != null) {
            this.vmArgs.addAll(this.profile.getVmArgs());
        }
        this.vmArgs.add("-cp");
        this.vmArgs.add(this.profile.getClassPath());
        this.vmArgs.add(this.profile.getMainClass());
        if (this.profile.getArgs() != null) {
            this.vmArgs.addAll(this.profile.getArgs());
        }
        if (this.profile.getDirectory() != null) {
            builder.directory(this.profile.getDirectory().toFile());
        }
        if (this.profile.isRedirectErrorStream()) {
            builder.redirectErrorStream(true);
        }
        if (this.launchingEvent != null) {
            this.launchingEvent.onLaunching(builder);
        }
        builder.command(this.vmArgs);
        StringBuilder entireCommand = new StringBuilder();
        for (String command : this.vmArgs) {
            entireCommand.append(command).append(" ");
        }
        LogUtil.info("ent", ":", entireCommand.toString());
        LogUtil.info("start", this.profile.getMainClass());
        try {
            Process p = builder.start();
            if (this.logsEnabled) {
                ProcessLogManager manager = new ProcessLogManager(p.getInputStream());
                manager.start();
            }
            return p;
        }
        catch (IOException e) {
            throw new LaunchException("Cannot launch !", e);
        }
    }

    public BeforeLaunchingEvent getLaunchingEvent() {
        return this.launchingEvent;
    }

    public void setLaunchingEvent(BeforeLaunchingEvent launchingEvent) {
        this.launchingEvent = launchingEvent;
    }

    public ExternalLaunchProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ExternalLaunchProfile profile) {
        this.profile = profile;
    }

    @ModifiedByFlow
    public List<String> getVmArgs() {
        return this.vmArgs;
    }

    @ModifiedByFlow
    public void setVmArgs(List<String> vmArgs) {
        this.vmArgs = vmArgs;
    }
}

