/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.flowarg.openlauncherlib.IForgeArgumentsProvider;
import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.flowarg.openlauncherlib.NewForgeVersionDiscriminator;
import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.GameFolder;
import fr.theshark34.openlauncherlib.minecraft.GameInfos;
import fr.theshark34.openlauncherlib.minecraft.GameVersion;
import java.util.ArrayList;
import java.util.List;

@ModifiedByFlow
public abstract class GameType
implements IForgeArgumentsProvider {
    private NewForgeVersionDiscriminator nfvd;
    public static final GameType V1_5_2_LOWER = new GameType(){

        @Override
        public String getName() {
            return "1.5.2 or lower";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.launchwrapper.Launch";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(authInfos.getUsername());
            arguments.add("token:" + authInfos.getAccessToken() + ":" + authInfos.getUuid());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().toString());
            arguments.add("--assetsDir");
            arguments.add(infos.getGameDir().resolve(folder.getAssetsFolder()).resolve("virtual").resolve("legacy").toString());
            return arguments;
        }
    };
    public static final GameType V1_7_2_LOWER = new GameType(){

        @Override
        public String getName() {
            return "1.7.2 or lower";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + authInfos.getUsername());
            arguments.add("--accessToken");
            arguments.add(authInfos.getAccessToken());
            arguments.add("--version");
            arguments.add(infos.getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().toString());
            arguments.add("--assetsDir");
            arguments.add(infos.getGameDir().resolve(folder.getAssetsFolder()).resolve("virtual").resolve("legacy").toString());
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(authInfos.getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };
    public static final GameType V1_7_10 = new GameType(){

        @Override
        public String getName() {
            return "1.7.10";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            return GameType.getOldVanillaArguments((GameType)this, authInfos, folder, infos);
        }
    };
    public static final GameType V1_8_HIGHER = new GameType(){

        @Override
        public String getName() {
            return "1.8 or higher";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            return GameType.getOldVanillaArguments((GameType)this, authInfos, folder, infos);
        }
    };
    public static final GameType V1_13_HIGHER_FORGE = new GameType(){

        @Override
        public String getName() {
            return "1.13.x or higher with Forge";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "cpw.mods.modlauncher.Launcher";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> args = new ArrayList<String>(GameType.getNewVanillaArguments(authInfos, folder, infos));
            if (this.getNFVD() == null) {
                throw new IllegalStateException("You must set an instance of NewForgeVersionDiscriminator (NFVD)");
            }
            args.addAll(this.getForgeArguments());
            return args;
        }
    };
    public static final GameType V1_13_HIGHER_VANILLA = new GameType(){

        @Override
        public String getName() {
            return "1.13.x or higher";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            return GameType.getNewVanillaArguments(authInfos, folder, infos);
        }
    };
    public static final GameType FABRIC = new GameType(){

        @Override
        public String getName() {
            return "Fabric";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.fabricmc.loader.launch.knot.KnotClient";
        }

        @Override
        public List<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            return GameType.getNewVanillaArguments(authInfos, folder, infos);
        }
    };

    private static List<String> getOldVanillaArguments(GameType type, AuthInfos authInfos, GameFolder folder, GameInfos infos) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--username=" + authInfos.getUsername());
        arguments.add("--accessToken");
        arguments.add(authInfos.getAccessToken());
        if (authInfos.getClientToken() != null) {
            arguments.add("--clientToken");
            arguments.add(authInfos.getClientToken());
        }
        arguments.add("--version");
        arguments.add(infos.getGameVersion().getName());
        arguments.add("--gameDir");
        arguments.add(infos.getGameDir().toString());
        arguments.add("--assetsDir");
        arguments.add(infos.getGameDir().resolve(folder.getAssetsFolder()).toString());
        arguments.add("--assetIndex");
        arguments.add(GameType.getAssetIndex(type, infos.getGameVersion()));
        arguments.add("--userProperties");
        arguments.add("{}");
        arguments.add("--uuid");
        arguments.add(authInfos.getUuid());
        arguments.add("--userType");
        arguments.add("legacy");
        return arguments;
    }

    private static List<String> getNewVanillaArguments(AuthInfos authInfos, GameFolder folder, GameInfos infos) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--username");
        arguments.add(authInfos.getUsername());
        arguments.add("--version");
        arguments.add(infos.getGameVersion().getName());
        arguments.add("--gameDir");
        arguments.add(infos.getGameDir().toString());
        arguments.add("--assetsDir");
        arguments.add(infos.getGameDir().resolve(folder.getAssetsFolder()).toString());
        arguments.add("--assetIndex");
        String versionName = infos.getGameVersion().getName();
        long times = versionName.chars().filter(value -> value == 46).count();
        if (times == 2L) {
            arguments.add(versionName.substring(0, versionName.lastIndexOf(46)));
        } else {
            arguments.add(versionName);
        }
        arguments.add("--uuid");
        arguments.add(authInfos.getUuid());
        arguments.add("--accessToken");
        arguments.add(authInfos.getAccessToken());
        arguments.add("--userType");
        arguments.add("mojang");
        arguments.add("--versionType");
        arguments.add("release");
        return arguments;
    }

    public abstract String getName();

    public abstract String getMainClass(GameInfos var1);

    public abstract List<String> getLaunchArgs(GameInfos var1, GameFolder var2, AuthInfos var3);

    @Override
    public NewForgeVersionDiscriminator getNFVD() {
        return this.nfvd;
    }

    @Deprecated
    public GameType setNewForgeVersionDiscriminator(NewForgeVersionDiscriminator nfvd) {
        this.nfvd = nfvd;
        return this;
    }

    public GameType setNFVD(NewForgeVersionDiscriminator nfvd) {
        this.nfvd = nfvd;
        return this;
    }

    private static String getAssetIndex(GameType type, GameVersion gameVersion) {
        if (type.equals(V1_8_HIGHER)) {
            int second;
            String version = gameVersion.getName();
            int first = version.indexOf(46);
            if (first != (second = version.lastIndexOf(46))) {
                version = version.substring(0, version.lastIndexOf(46));
            }
            if (gameVersion.getName().equals("1.13.1") || gameVersion.getName().equals("1.13.2")) {
                version = "1.13.1";
            }
            return version;
        }
        return gameVersion.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GameType) {
            GameType o = (GameType)obj;
            return o.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

