/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.configuration.core.DefaultConfigurationManager;
import fr.theshark34.openlauncherlib.language.api.LanguageInfo;
import fr.theshark34.openlauncherlib.language.api.LanguageManager;
import fr.theshark34.openlauncherlib.language.api.LanguageTypes;
import fr.theshark34.openlauncherlib.language.core.DefaultLanguageManager;
import java.util.Locale;
import java.util.logging.Logger;

public final class LogUtil {
    private static final LanguageManager LANGUAGE_MANAGER = new DefaultLanguageManager(Logger.getLogger("OpenLauncherLib"), new DefaultConfigurationManager(Logger.getLogger("OpenLauncherLib")));
    private static final LanguageInfo IDENTIFIER = () -> "OpenLauncherLib";

    public static LanguageManager getLanguageManager() {
        return LANGUAGE_MANAGER;
    }

    public static LanguageInfo getIdentifier() {
        return IDENTIFIER;
    }

    @ModifiedByFlow
    public static void message(boolean err, String ... messages) {
        StringBuilder builder = new StringBuilder("[OpenLauncherLib]");
        for (String node : messages) {
            builder.append(" ").append(LANGUAGE_MANAGER.getDefaultLanguage().get(IDENTIFIER, node));
        }
        if (err) {
            System.err.println(builder);
        } else {
            System.out.println(builder);
        }
    }

    public static void rawInfo(String message) {
        System.out.println("[OpenLauncherLib] " + message);
    }

    public static void rawErr(String message) {
        System.err.println("[OpenLauncherLib] " + message);
    }

    public static void info(String ... messages) {
        LogUtil.message(false, messages);
    }

    public static void err(String ... messages) {
        LogUtil.message(true, messages);
    }

    static {
        LANGUAGE_MANAGER.registerLanguage(IDENTIFIER, LanguageTypes.EN, "/assets/languages/");
        LANGUAGE_MANAGER.registerLanguage(IDENTIFIER, LanguageTypes.FR, "/assets/languages/");
        if (Locale.getDefault().getLanguage().toLowerCase().startsWith("fr")) {
            LANGUAGE_MANAGER.setDefaultLanguage(LANGUAGE_MANAGER.getLanguage(LanguageTypes.FR));
        } else {
            LANGUAGE_MANAGER.setDefaultLanguage(LANGUAGE_MANAGER.getLanguage(LanguageTypes.EN));
        }
    }
}

