/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util.ramselector;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.util.CrashReporter;
import fr.theshark34.openlauncherlib.util.LogUtil;
import fr.theshark34.openlauncherlib.util.ramselector.AbstractOptionFrame;
import fr.theshark34.openlauncherlib.util.ramselector.OptionFrame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.swing.JFrame;

@ModifiedByFlow
public class RamSelector {
    public static final String[] RAM_ARRAY = new String[]{"1Go", "2Go", "3Go", "4Go", "5Go", "6Go", "7Go", "8Go", "9Go", "10Go"};
    private Path file;
    private Class<? extends AbstractOptionFrame> frameClass = OptionFrame.class;
    private AbstractOptionFrame frame;

    @Deprecated
    public RamSelector(File file) {
        this.file = file.toPath();
    }

    public RamSelector(Path path) {
        this.file = path;
    }

    public JFrame display() {
        if (this.frame == null) {
            try {
                Constructor<?>[] constructors = this.frameClass.getDeclaredConstructors();
                Constructor<?> constructor = null;
                for (Constructor<?> c : constructors) {
                    if (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != RamSelector.class) continue;
                    constructor = c;
                }
                if (constructor == null) {
                    throw new IllegalStateException("Can't load the OptionFrame class, it needs to have a constructor with just a RamSelector as argument.");
                }
                this.frame = (AbstractOptionFrame)constructor.newInstance(this);
                this.frame.setSelectedIndex(this.readRam());
            }
            catch (Exception e) {
                System.err.println("[OpenLauncherLib] Can't display the Ram Selector !");
                System.err.println(CrashReporter.makeCrashReport("OpenLauncherLib Ram Selector", e));
                return null;
            }
        }
        this.frame.setVisible(true);
        return this.frame;
    }

    @ModifiedByFlow
    public String[] getRamArguments() {
        int maxRam = Integer.parseInt(this.frame == null ? RAM_ARRAY[this.readRam()].replace("Go", "") : RAM_ARRAY[this.frame.getSelectedIndex()].replace("Go", "")) * 1024;
        int minRam = maxRam - 1024;
        if (maxRam - 1024 <= 0) {
            minRam = 128;
        }
        return new String[]{"-Xms" + minRam + "M", "-Xmx" + maxRam + "M"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readRam() {
        try (BufferedReader br = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
            String ramText = br.readLine();
            if (ramText != null) {
                int n = Integer.parseInt(ramText);
                return n;
            }
            LogUtil.err("warn", "ram-empty");
            return 0;
        }
        catch (IOException e) {
            System.err.println("[OpenLauncherLib] WARNING: Can't read ram : " + e);
        }
        return 0;
    }

    public void save() {
        if (this.frame == null) {
            return;
        }
        try (BufferedWriter bw = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
            bw.write(String.valueOf(this.frame.getSelectedIndex()));
        }
        catch (IOException e) {
            System.err.println("[OpenLauncherLib] WARNING: Can't save ram : " + e);
        }
    }

    public Path getFile() {
        return this.file;
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public Class<? extends JFrame> getFrameClass() {
        return this.frameClass;
    }

    public void setFrameClass(Class<? extends AbstractOptionFrame> frameClass) {
        this.frameClass = frameClass;
    }
}

