/*
 * Decompiled with CFR 0.152.
 */
package fr.fxjavadevblog.preconditions;

import fr.fxjavadevblog.preconditions.PreconditionMessage;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class Checker {
    private Checker() {
    }

    public static void notNull(String argumentName, Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException(PreconditionMessage.SHOULD_NOT_BE_NULL.format(argumentName));
        }
    }

    public static void notNull(String argumentName, Object arg, Function<String, ? extends RuntimeException> exceptionSupplier) {
        if (arg == null) {
            throw exceptionSupplier.apply(argumentName);
        }
    }

    public static void inRange(String argumentName, Integer arg, Integer min, Integer max) {
        if (arg == null || arg < min || arg > max) {
            throw new IllegalArgumentException(PreconditionMessage.SHOULD_BE_BETWEEN.format(argumentName, min, max));
        }
    }

    public static void inRange(String argumentName, Integer arg, int min, int max, BiFunction<String, Integer, ? extends RuntimeException> exceptionSupplier) {
        if (arg == null || arg < min || arg > max) {
            throw exceptionSupplier.apply(argumentName, arg);
        }
    }

    public static void notEmpty(String argumentName, Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(PreconditionMessage.SHOULD_NOT_BE_EMPTY.format(argumentName));
        }
    }

    public static void respects(String argumentName, String arg, Pattern pattern) {
        if (!pattern.matcher(arg).matches()) {
            throw new IllegalArgumentException(PreconditionMessage.SHOULD_MATCH_REGEXP.format(argumentName, pattern.toString()));
        }
    }

    public static void respects(String argumentName, BooleanSupplier predicate, String message) {
        if (!predicate.getAsBoolean()) {
            throw new IllegalArgumentException(PreconditionMessage.SHOULD_RESPECT_BOOLEAN_CONDITION.format(argumentName, message));
        }
    }

    public static <T> void respects(String argumentName, T t, Predicate<T> predicate, String message) {
        if (!predicate.test(t)) {
            throw new IllegalArgumentException(PreconditionMessage.SHOULD_RESPECT_BOOLEAN_CONDITION.format(argumentName, message));
        }
    }

    public static <T> void respects(String argumentName, T t, Predicate<T> predicate, BiFunction<String, T, ? extends RuntimeException> function) {
        if (!predicate.test(t)) {
            throw function.apply(argumentName, (String)t);
        }
    }

    public static void notAnyNullValue(String argumentName, Map<?, ?> map) {
        Checker.notNull("map", map);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (e.getValue() != null) continue;
            throw new IllegalArgumentException(PreconditionMessage.MAP_SHOULD_NOT_CONTAIN_ANY_NULL_REFERENCE.format(argumentName, e.getKey()));
        }
    }
}

