/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon;

import com.github.gumtreediff.matchers.GumtreeProperties;
import gumtree.spoon.builder.SpoonGumTreeBuilder;
import gumtree.spoon.diff.Diff;
import gumtree.spoon.diff.DiffConfiguration;
import gumtree.spoon.diff.DiffImpl;
import java.io.File;
import java.util.Map;
import spoon.compiler.Environment;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.support.DefaultCoreFactory;
import spoon.support.StandardEnvironment;
import spoon.support.compiler.VirtualFile;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;

public class AstComparator {
    private boolean includeComments = false;

    public AstComparator() {
    }

    public AstComparator(boolean includeComments) {
        this.includeComments = includeComments;
    }

    public AstComparator(Map<String, String> configuration) {
        for (String k : configuration.keySet()) {
            System.setProperty(k, configuration.get(k));
        }
    }

    protected Factory createFactory() {
        FactoryImpl factory = new FactoryImpl((CoreFactory)new DefaultCoreFactory(), (Environment)new StandardEnvironment());
        factory.getEnvironment().setNoClasspath(true);
        factory.getEnvironment().setCommentEnabled(this.includeComments);
        return factory;
    }

    public Diff compare(File f1, File f2) throws Exception {
        return this.compare((CtElement)this.getCtType(f1), (CtElement)this.getCtType(f2));
    }

    public Diff compare(String left, String right) {
        return this.compare((CtElement)this.getCtType(left), (CtElement)this.getCtType(right));
    }

    public Diff compare(File f1, File f2, GumtreeProperties properties) throws Exception {
        return this.compare((CtElement)this.getCtType(f1), (CtElement)this.getCtType(f2), properties);
    }

    public Diff compare(String left, String right, GumtreeProperties properties) {
        return this.compare((CtElement)this.getCtType(left), (CtElement)this.getCtType(right), properties);
    }

    public Diff compare(String left, String right, String filenameLeft, String filenameRight, GumtreeProperties properties) {
        return this.compare((CtElement)this.getCtType(left, filenameLeft), (CtElement)this.getCtType(right, filenameRight), properties);
    }

    public Diff compare(String left, String right, String filenameLeft, String filenameRight) {
        return this.compare((CtElement)this.getCtType(left, filenameLeft), (CtElement)this.getCtType(right, filenameRight));
    }

    public Diff compare(CtElement left, CtElement right) {
        SpoonGumTreeBuilder scanner = new SpoonGumTreeBuilder();
        return new DiffImpl(scanner.getTreeContext(), scanner.getTree(left), scanner.getTree(right));
    }

    public Diff compare(CtElement left, CtElement right, GumtreeProperties properties) {
        SpoonGumTreeBuilder scanner = new SpoonGumTreeBuilder();
        return new DiffImpl(scanner.getTreeContext(), scanner.getTree(left), scanner.getTree(right), properties);
    }

    public Diff compare(File f1, File f2, DiffConfiguration configuration) throws Exception {
        SpoonGumTreeBuilder scanner = new SpoonGumTreeBuilder();
        return new DiffImpl(scanner.getTreeContext(), scanner.getTree((CtElement)this.getCtType(f1)), scanner.getTree((CtElement)this.getCtType(f2)), configuration);
    }

    public CtType getCtType(File file) throws Exception {
        SpoonResource resource = SpoonResourceHelper.createResource((File)file);
        return this.getCtType(resource);
    }

    public CtType getCtType(SpoonResource resource) {
        Factory factory = this.createFactory();
        factory.getModel().setBuildModelIsFinished(false);
        JDTBasedSpoonCompiler compiler = new JDTBasedSpoonCompiler(factory);
        compiler.getFactory().getEnvironment().setLevel("OFF");
        compiler.addInputSource(resource);
        compiler.build();
        if (factory.Type().getAll().size() == 0) {
            return null;
        }
        CtType type = (CtType)factory.Type().getAll().get(0);
        return factory.Type().get(type.getQualifiedName());
    }

    public CtType<?> getCtType(String content) {
        return this.getCtType(content, "/test");
    }

    public CtType<?> getCtType(String content, String filename) {
        VirtualFile resource = new VirtualFile(content, filename);
        return this.getCtType((SpoonResource)resource);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: DiffSpoon <file_1>  <file_2>");
            return;
        }
        Diff result = new AstComparator().compare(new File(args[0]), new File(args[1]));
        System.out.println(result.toString());
    }

    static {
        System.setProperty("gt.bum.smt", "0.6");
        System.setProperty("gt.stm.mh", "1");
    }
}

