/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.builder;

import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gumtree.spoon.builder.SpoonGumTreeBuilder;
import gumtree.spoon.builder.jsonsupport.NodePainter;
import gumtree.spoon.builder.jsonsupport.OperationNodePainter;
import gumtree.spoon.diff.operations.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import spoon.reflect.declaration.CtElement;

public class Json4SpoonGenerator {
    public JsonObject getJSONasJsonObject(CtElement element) {
        SpoonGumTreeBuilder builder = new SpoonGumTreeBuilder();
        Tree generatedTree = builder.getTree(element);
        TreeContext tcontext = builder.getTreeContext();
        return this.getJSONasJsonObject(tcontext, generatedTree);
    }

    public String getJSONasString(CtElement element) {
        SpoonGumTreeBuilder builder = new SpoonGumTreeBuilder();
        Tree generatedTree = builder.getTree(element);
        TreeContext tcontext = builder.getTreeContext();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)this.getJSONasJsonObject(tcontext, generatedTree)) + "\n";
    }

    public JsonObject getJSONasJsonObject(TreeContext context, Tree tree) {
        JsonObject o = new JsonObject();
        o.addProperty(JSON_PROPERTIES.label.toString(), tree.getLabel());
        o.addProperty(JSON_PROPERTIES.type.toString(), tree.getType().name);
        JsonArray nodeChildens = new JsonArray();
        o.add(JSON_PROPERTIES.children.toString(), (JsonElement)nodeChildens);
        for (Tree tch : tree.getChildren()) {
            JsonObject childJSon = this.getJSONasJsonObject(context, tch);
            if (childJSon == null) continue;
            nodeChildens.add((JsonElement)childJSon);
        }
        return o;
    }

    public JsonObject getJSONwithOperations(TreeContext context, Tree tree, List<Operation> operations) {
        OperationNodePainter opNodePainter = new OperationNodePainter(operations);
        ArrayList<NodePainter> painters = new ArrayList<NodePainter>();
        painters.add(opNodePainter);
        return this.getJSONwithCustorLabels(context, tree, painters);
    }

    public JsonObject getJSONwithCustorLabels(TreeContext context, Tree tree, Collection<NodePainter> nodePainters) {
        JsonObject o = new JsonObject();
        o.addProperty(JSON_PROPERTIES.label.toString(), tree.getLabel());
        o.addProperty(JSON_PROPERTIES.type.toString(), tree.getType().name);
        for (NodePainter nodePainter : nodePainters) {
            nodePainter.paint(tree, o);
        }
        JsonArray nodeChildens = new JsonArray();
        o.add(JSON_PROPERTIES.children.toString(), (JsonElement)nodeChildens);
        for (Tree tch : tree.getChildren()) {
            JsonObject childJSon = this.getJSONwithCustorLabels(context, tch, nodePainters);
            if (childJSon == null) continue;
            nodeChildens.add((JsonElement)childJSon);
        }
        return o;
    }

    public static enum JSON_PROPERTIES {
        label,
        type,
        op,
        children;

    }
}

