/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.builder;

import java.lang.annotation.Annotation;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtInheritanceScanner;

class LabelFinder
extends CtInheritanceScanner {
    public String label = "";

    LabelFinder() {
    }

    public void scanCtNamedElement(CtNamedElement e) {
        this.label = e.getSimpleName();
    }

    public <T> void scanCtVariableAccess(CtVariableAccess<T> variableAccess) {
        this.label = variableAccess.getVariable().getSimpleName();
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtType parentType;
        this.label = invocation.getExecutable().isConstructor() ? ((parentType = (CtType)invocation.getParent(CtType.class)).getQualifiedName().equals(invocation.getExecutable().getDeclaringType().getQualifiedName()) ? "this" : "super") : invocation.getExecutable().getSimpleName();
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.label = ctConstructorCall.getExecutable().getSignature();
    }

    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.label = literal.toString();
    }

    public void visitCtIf(CtIf e) {
        this.label = "if";
    }

    public void visitCtWhile(CtWhile e) {
        this.label = "while";
    }

    public void visitCtBreak(CtBreak e) {
        this.label = "break";
    }

    public void visitCtContinue(CtContinue e) {
        this.label = "continue";
    }

    public <R> void visitCtReturn(CtReturn<R> e) {
        this.label = "return";
    }

    public <T> void visitCtAssert(CtAssert<T> e) {
        this.label = "assert";
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> e) {
        this.label = "=";
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> e) {
        this.label = e.getLabel();
    }

    public <R> void visitCtBlock(CtBlock<R> e) {
        this.label = e.getRoleInParent() == CtRole.ELSE ? "ELSE" : (e.getRoleInParent() == CtRole.THEN ? "THEN" : "{");
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.label = operator.getKind().toString();
    }

    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.label = operator.getKind().toString();
    }

    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.label = thisAccess.toString();
    }

    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.label = f.toString();
    }

    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        if (typeAccess.getAccessedType() != null) {
            this.label = typeAccess.getAccessedType().getQualifiedName();
        }
    }

    public void visitCtComment(CtComment comment) {
        this.label = comment.getContent();
    }

    public <T extends Annotation> void visitCtAnnotation(CtAnnotation<T> annotation) {
        this.label = annotation.getType().getQualifiedName();
    }

    public <T> void visitCtTypeReference(CtTypeReference<T> e) {
        this.label = e.getQualifiedName();
    }
}

