/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.builder;

import com.github.gumtreediff.tree.Tree;
import gumtree.spoon.builder.CtVirtualElement;
import gumtree.spoon.builder.CtWrapper;
import gumtree.spoon.builder.TreeScanner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import spoon.reflect.code.CtExpression;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.cu.position.SourcePositionImpl;

public class NodeCreator
extends CtInheritanceScanner {
    public static final String MODIFIERS = "Modifiers_";
    private final TreeScanner builder;

    NodeCreator(TreeScanner builder) {
        this.builder = builder;
    }

    public void scanCtModifiable(CtModifiable m) {
        if (m.getModifiers().isEmpty()) {
            return;
        }
        String type = MODIFIERS + this.getClassName(m.getClass().getSimpleName());
        Tree modifiers = this.builder.createNode(type, "");
        TreeSet<CtExtendedModifier> modifiers1 = new TreeSet<CtExtendedModifier>(Comparator.comparing(o -> o.getKind().name()));
        modifiers1.addAll(m.getExtendedModifiers());
        CtVirtualElement virtualElement = new CtVirtualElement(type, (CtElement)m, m.getModifiers(), CtRole.MODIFIER);
        modifiers.setMetadata("spoon_object", (Object)virtualElement);
        ArrayList<SourcePosition> modifierPositions = new ArrayList<SourcePosition>();
        for (CtExtendedModifier mod : modifiers1) {
            Tree modifier = this.builder.createNode("Modifier", mod.getKind().toString());
            modifiers.addChild(modifier);
            CtWrapper<ModifierKind> wrapper = new CtWrapper<ModifierKind>(mod.getKind(), (CtElement)m, CtRole.MODIFIER);
            wrapper.setPosition(mod.getPosition());
            modifierPositions.add(mod.getPosition());
            modifier.setMetadata("spoon_object", wrapper);
        }
        virtualElement.setPosition(NodeCreator.computeSourcePositionOfVirtualElement(modifierPositions));
        this.builder.addSiblingNode(modifiers);
    }

    private static SourcePosition computeSourcePositionOfVirtualElement(List<SourcePosition> modifierPositions) {
        CompilationUnit cu = null;
        Integer sourceStart = null;
        Integer sourceEnd = null;
        for (SourcePosition position : modifierPositions) {
            if (position instanceof NoSourcePosition) {
                return SourcePosition.NOPOSITION;
            }
            if (sourceStart == null || position.getSourceStart() < sourceStart) {
                sourceStart = position.getSourceStart();
            }
            if (sourceEnd == null || position.getSourceEnd() > sourceEnd) {
                sourceEnd = position.getSourceEnd();
            }
            if (cu != null) continue;
            cu = position.getCompilationUnit();
        }
        return new SourcePositionImpl(cu, sourceStart.intValue(), sourceEnd.intValue(), cu.getLineSeparatorPositions());
    }

    private String getClassName(String simpleName) {
        if (simpleName == null) {
            return "";
        }
        return simpleName.replace("Ct", "").replace("Impl", "");
    }

    public <T> void scanCtVariable(CtVariable<T> e) {
        CtTypeReference type = e.getType();
        if (type != null) {
            Tree variableType = this.builder.createNode("VARIABLE_TYPE", type.getQualifiedName());
            variableType.setMetadata("spoon_object", (Object)type);
            type.putMetadata("gtnode", (Object)variableType);
            this.computeTreeOfTypeReferences(type, variableType);
            this.builder.addSiblingNode(variableType);
        }
    }

    public void scanCtActualTypeContainer(CtActualTypeContainer reference) {
        for (CtTypeReference ctTypeArgument : reference.getActualTypeArguments()) {
            Tree typeArgument = this.builder.createNode("TYPE_ARGUMENT", ctTypeArgument.getQualifiedName());
            typeArgument.setMetadata("spoon_object", (Object)ctTypeArgument);
            ctTypeArgument.putMetadata("gtnode", (Object)typeArgument);
            this.computeTreeOfTypeReferences(ctTypeArgument, typeArgument);
            this.builder.addSiblingNode(typeArgument);
        }
    }

    public <T> void scanCtTypeInformation(CtTypeInformation typeReference) {
        if (typeReference.getSuperInterfaces().isEmpty()) {
            return;
        }
        Tree superInterfaceRoot = this.builder.createNode("SUPER_INTERFACES", "");
        String virtualNodeDescription = "SuperInterfaces_" + typeReference.getQualifiedName();
        superInterfaceRoot.setMetadata("spoon_object", (Object)new CtVirtualElement(virtualNodeDescription, (CtElement)typeReference, typeReference.getSuperInterfaces(), CtRole.INTERFACE));
        for (CtTypeReference superInterface : typeReference.getSuperInterfaces()) {
            Tree superInterfaceNode = this.builder.createNode("INTERFACE", superInterface.getQualifiedName());
            superInterfaceNode.setMetadata("spoon_object", (Object)superInterface);
            superInterface.putMetadata("gtnode", (Object)superInterfaceNode);
            superInterfaceRoot.addChild(superInterfaceNode);
            this.computeTreeOfTypeReferences(superInterface, superInterfaceNode);
        }
        this.builder.addSiblingNode(superInterfaceRoot);
    }

    private void computeTreeOfTypeReferences(CtTypeReference<?> type, Tree parentType) {
        for (CtTypeReference ctTypeArgument : type.getActualTypeArguments()) {
            Tree typeArgument = this.builder.createNode("TYPE_ARGUMENT", ctTypeArgument.getQualifiedName());
            typeArgument.setMetadata("spoon_object", (Object)ctTypeArgument);
            ctTypeArgument.putMetadata("gtnode", (Object)typeArgument);
            parentType.addChild(typeArgument);
            this.computeTreeOfTypeReferences(ctTypeArgument, typeArgument);
        }
    }

    public <T> void visitCtMethod(CtMethod<T> e) {
        CtTypeReference type = e.getType();
        if (type != null) {
            Tree returnType = this.builder.createNode("RETURN_TYPE", type.getQualifiedName());
            returnType.setMetadata("spoon_object", (Object)type);
            type.putMetadata("gtnode", (Object)returnType);
            this.computeTreeOfTypeReferences(type, returnType);
            this.builder.addSiblingNode(returnType);
        }
        if (!e.getThrownTypes().isEmpty()) {
            Tree thrownTypeRoot = this.builder.createNode("THROWN_TYPES", "");
            String virtualNodeDescription = "ThrownTypes_" + e.getSimpleName();
            thrownTypeRoot.setMetadata("spoon_object", (Object)new CtVirtualElement(virtualNodeDescription, (CtElement)e, e.getThrownTypes(), CtRole.THROWN));
            for (CtTypeReference thrownType : e.getThrownTypes()) {
                Tree thrownNode = this.builder.createNode("THROWN", thrownType.getQualifiedName());
                thrownNode.setMetadata("spoon_object", (Object)thrownType);
                thrownType.putMetadata("gtnode", (Object)thrownNode);
                thrownTypeRoot.addChild(thrownNode);
            }
            this.builder.addSiblingNode(thrownTypeRoot);
        }
        super.visitCtMethod(e);
    }

    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        if (annotation.getValues().isEmpty()) {
            return;
        }
        String virtualNodeDescription = "AnnotationValues_" + this.getClassName(annotation.getClass().getSimpleName());
        Tree annotationNode = this.builder.createNode(virtualNodeDescription, "");
        annotationNode.setMetadata("spoon_object", (Object)new CtVirtualElement(virtualNodeDescription, (CtElement)annotation, annotation.getValues().entrySet(), CtRole.VALUE));
        for (Map.Entry entry : annotation.getValues().entrySet()) {
            Tree annotationValueNode = this.builder.createNode("ANNOTATION_VALUE", entry.toString());
            annotationNode.addChild(annotationValueNode);
            CtWrapper wrapper = new CtWrapper(entry, (CtElement)annotation, CtRole.VALUE);
            wrapper.setPosition(((CtExpression)entry.getValue()).getPosition());
            annotationValueNode.setMetadata("spoon_object", wrapper);
        }
        this.builder.addSiblingNode(annotationNode);
    }

    public <T> void scanCtTypedElement(CtTypedElement<T> e) {
        if (e instanceof CtExpression) {
            CtExpression expression = (CtExpression)e;
            for (CtTypeReference ctTypeCast : expression.getTypeCasts()) {
                Tree typeCast = this.builder.createNode("TYPE_CAST", ctTypeCast.getQualifiedName());
                typeCast.setMetadata("spoon_object", (Object)ctTypeCast);
                ctTypeCast.putMetadata("gtnode", (Object)typeCast);
                this.computeTreeOfTypeReferences(ctTypeCast, typeCast);
                this.builder.addSiblingNode(typeCast);
            }
        }
    }
}

