/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.builder;

import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import com.github.gumtreediff.tree.Type;
import com.github.gumtreediff.tree.TypeSet;
import gumtree.spoon.builder.LabelFinder;
import gumtree.spoon.builder.NodeCreator;
import java.util.Stack;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtScanner;

public class TreeScanner
extends CtScanner {
    public static final String NOTYPE = "<notype>";
    private final TreeContext treeContext;
    private final Stack<Tree> nodes = new Stack();
    boolean nolabel = false;

    TreeScanner(TreeContext treeContext, Tree root) {
        this.treeContext = treeContext;
        this.nodes.push(root);
        this.nolabel = this.isNoLabelMode();
    }

    public void enter(CtElement element) {
        if (this.isToIgnore(element)) {
            super.enter(element);
            return;
        }
        String label = null;
        String nodeTypeName = this.getNodeType(element);
        if (this.nolabel) {
            label = nodeTypeName;
        } else {
            LabelFinder lf = new LabelFinder();
            lf.scan(element);
            label = lf.label;
        }
        this.pushNodeToTree(this.createNode(nodeTypeName, element, label));
        int depthBefore = this.nodes.size();
        new NodeCreator(this).scan(element);
        if (this.nodes.size() != depthBefore) {
            throw new RuntimeException("too many nodes pushed");
        }
    }

    public boolean isNoLabelMode() {
        String nolabel = System.getProperty("nolabel");
        if (nolabel != null) {
            return Boolean.valueOf(nolabel);
        }
        return false;
    }

    private boolean isToIgnore(CtElement element) {
        if (element instanceof CtStatementList && !(element instanceof CtCase)) {
            return element.getRoleInParent() != CtRole.ELSE && element.getRoleInParent() != CtRole.THEN;
        }
        if (element instanceof CtReference && element.getRoleInParent() == CtRole.SUPER_TYPE) {
            return false;
        }
        if (element instanceof CtLiteral && element.getParent() instanceof CtAnnotation) {
            return true;
        }
        return element.isImplicit() || element instanceof CtReference;
    }

    public void exit(CtElement element) {
        if (!this.isToIgnore(element)) {
            this.nodes.pop();
        }
        super.exit(element);
    }

    private void pushNodeToTree(Tree node) {
        Tree parent = this.nodes.peek();
        if (parent != null) {
            parent.addChild(node);
        }
        this.nodes.push(node);
    }

    void addSiblingNode(Tree node) {
        Tree parent = this.nodes.peek();
        if (parent != null) {
            parent.addChild(node);
        }
    }

    private String getNodeType(CtElement element) {
        String nodeTypeName = NOTYPE;
        if (element != null) {
            nodeTypeName = this.getTypeName(element.getClass().getSimpleName());
        }
        if (element instanceof CtBlock) {
            nodeTypeName = element.getRoleInParent().toString();
        }
        if (element.getRoleInParent() == CtRole.SUPER_TYPE) {
            nodeTypeName = "SUPER_TYPE";
        }
        return nodeTypeName;
    }

    private Tree createNode(String nodeTypeName, CtElement element, String label) {
        Tree newNode = this.createNode(nodeTypeName, label);
        newNode.setMetadata("spoon_object", (Object)element);
        element.putMetadata("gtnode", (Object)newNode);
        return newNode;
    }

    private String getTypeName(String simpleName) {
        return simpleName.substring(2, simpleName.length() - 4);
    }

    public Tree createNode(String typeClass, String label) {
        Type type = TypeSet.type((String)typeClass);
        return this.treeContext.createTree(type, label);
    }
}

