/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.diff;

import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.actions.model.Delete;
import com.github.gumtreediff.actions.model.Insert;
import com.github.gumtreediff.actions.model.Move;
import com.github.gumtreediff.actions.model.Update;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.tree.Tree;
import gumtree.spoon.diff.Diff;
import gumtree.spoon.diff.operations.DeleteOperation;
import gumtree.spoon.diff.operations.InsertOperation;
import gumtree.spoon.diff.operations.MoveOperation;
import gumtree.spoon.diff.operations.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionClassifier {
    private List<Tree> srcUpdTrees = new ArrayList<Tree>();
    private List<Tree> dstUpdTrees = new ArrayList<Tree>();
    private List<Tree> srcMvTrees = new ArrayList<Tree>();
    private List<Tree> dstMvTrees = new ArrayList<Tree>();
    private List<Tree> srcDelTrees = new ArrayList<Tree>();
    private List<Tree> dstAddTrees = new ArrayList<Tree>();
    private Map<Tree, Action> originalActionsSrc = new HashMap<Tree, Action>();
    private Map<Tree, Action> originalActionsDst = new HashMap<Tree, Action>();

    public ActionClassifier(MappingStore mappings, List<Action> actions) {
        this.clean();
        for (Action action : actions) {
            Tree dest;
            Tree original = action.getNode();
            if (action instanceof Delete) {
                this.srcDelTrees.add(original);
                this.originalActionsSrc.put(original, action);
                continue;
            }
            if (action instanceof Insert) {
                this.dstAddTrees.add(original);
                this.originalActionsDst.put(original, action);
                continue;
            }
            if (action instanceof Update) {
                dest = mappings.getDstForSrc(original);
                this.srcUpdTrees.add(original);
                this.dstUpdTrees.add(dest);
                this.originalActionsSrc.put(original, action);
                continue;
            }
            if (!(action instanceof Move)) continue;
            dest = mappings.getDstForSrc(original);
            this.srcMvTrees.add(original);
            this.dstMvTrees.add(dest);
            this.originalActionsDst.put(dest, action);
        }
    }

    public List<Action> getRootActions() {
        List<Action> rootActions = this.srcUpdTrees.stream().map(t -> this.originalActionsSrc.get(t)).collect(Collectors.toList());
        rootActions.addAll(this.srcDelTrees.stream().filter(t -> !this.srcDelTrees.contains(t.getParent()) && !this.srcUpdTrees.contains(t.getParent())).map(t -> this.originalActionsSrc.get(t)).collect(Collectors.toList()));
        rootActions.addAll(this.dstAddTrees.stream().filter(t -> !this.dstAddTrees.contains(t.getParent()) && !this.dstUpdTrees.contains(t.getParent())).map(t -> this.originalActionsDst.get(t)).collect(Collectors.toList()));
        rootActions.addAll(this.dstMvTrees.stream().filter(t -> !this.dstMvTrees.contains(t.getParent())).map(t -> this.originalActionsDst.get(t)).collect(Collectors.toList()));
        rootActions.removeAll(Collections.singleton(null));
        return rootActions;
    }

    private void clean() {
        this.srcUpdTrees.clear();
        this.dstUpdTrees.clear();
        this.srcMvTrees.clear();
        this.dstMvTrees.clear();
        this.srcDelTrees.clear();
        this.dstAddTrees.clear();
        this.originalActionsSrc.clear();
        this.originalActionsDst.clear();
    }

    public static List<Operation> replaceMoveFromAll(Diff editScript) {
        return ActionClassifier.replaceMove(editScript.getMappingsComp(), editScript.getAllOperations(), true);
    }

    public static List<Operation> replaceMoveFromRoots(Diff editScript) {
        return ActionClassifier.replaceMove(editScript.getMappingsComp(), editScript.getRootOperations(), false);
    }

    public static List<Operation> replaceMove(MappingStore mapping, List<Operation> ops, boolean all) {
        ArrayList<Operation> newOps = new ArrayList<Operation>();
        List<Tree> dels = ops.stream().filter(e -> e instanceof DeleteOperation).map(e -> e.getAction().getNode()).collect(Collectors.toList());
        List<Tree> inss = ops.stream().filter(e -> e instanceof InsertOperation).map(e -> e.getAction().getNode()).collect(Collectors.toList());
        for (Operation operation : ops) {
            if (operation instanceof MoveOperation) {
                MoveOperation movOp = (MoveOperation)operation;
                Tree node = ((Move)movOp.getAction()).getNode();
                Delete deleteAction = new Delete(node);
                DeleteOperation delOp = new DeleteOperation(deleteAction);
                if (all || !ActionClassifier.inParent(dels, node.getParent())) {
                    newOps.add(delOp);
                }
                Tree dstNode = mapping.getDstForSrc(node);
                Tree parentInAction = ((Move)movOp.getAction()).getParent();
                Tree parent = mapping.isDstMapped(parentInAction) ? mapping.getDstForSrc(parentInAction) : parentInAction;
                int pos = movOp.getPosition();
                Insert insertAc = new Insert(dstNode, parent, pos);
                InsertOperation insertOp = new InsertOperation(insertAc);
                if (!all && ActionClassifier.inParent(inss, parentInAction)) continue;
                newOps.add(insertOp);
                continue;
            }
            newOps.add(operation);
        }
        return newOps;
    }

    public static boolean inParent(List<Tree> trees, Tree parent) {
        if (parent == null) {
            return false;
        }
        if (trees.contains(parent)) {
            return true;
        }
        return ActionClassifier.inParent(trees, parent.getParent());
    }
}

