/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.diff;

import com.github.gumtreediff.actions.ChawatheScriptGenerator;
import com.github.gumtreediff.actions.EditScript;
import com.github.gumtreediff.actions.SimplifiedChawatheScriptGenerator;
import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.actions.model.Delete;
import com.github.gumtreediff.actions.model.Insert;
import com.github.gumtreediff.actions.model.Move;
import com.github.gumtreediff.actions.model.TreeDelete;
import com.github.gumtreediff.actions.model.TreeInsert;
import com.github.gumtreediff.actions.model.Update;
import com.github.gumtreediff.matchers.CompositeMatchers;
import com.github.gumtreediff.matchers.GumtreeProperties;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.matchers.Matcher;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import gumtree.spoon.diff.ActionClassifier;
import gumtree.spoon.diff.Diff;
import gumtree.spoon.diff.DiffConfiguration;
import gumtree.spoon.diff.operations.DeleteOperation;
import gumtree.spoon.diff.operations.DeleteTreeOperation;
import gumtree.spoon.diff.operations.InsertOperation;
import gumtree.spoon.diff.operations.InsertTreeOperation;
import gumtree.spoon.diff.operations.MoveOperation;
import gumtree.spoon.diff.operations.Operation;
import gumtree.spoon.diff.operations.OperationKind;
import gumtree.spoon.diff.operations.UpdateOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import spoon.reflect.declaration.CtElement;

public class DiffImpl
implements Diff {
    private List<Operation> allOperations;
    private List<Operation> rootOperations;
    private List<Operation> simplifiedOperations;
    private MappingStore _mappingsComp;
    private TreeContext context;
    private GumtreeProperties properties = null;
    private Matcher matcher = new CompositeMatchers.ClassicGumtree();

    public DiffImpl(TreeContext context, Tree rootSpoonLeft, Tree rootSpoonRight, GumtreeProperties properties) {
        this.properties = properties;
        this.computeDiff(context, rootSpoonLeft, rootSpoonRight);
    }

    public DiffImpl(TreeContext context, Tree rootSpoonLeft, Tree rootSpoonRight, DiffConfiguration configuration) {
        this.matcher = configuration.getMatcher();
        this.computeDiff(context, rootSpoonLeft, rootSpoonRight);
    }

    public DiffImpl(TreeContext context, Tree rootSpoonLeft, Tree rootSpoonRight) {
        this.computeDiff(context, rootSpoonLeft, rootSpoonRight);
    }

    public void computeDiff(TreeContext context, Tree rootSpoonLeft, Tree rootSpoonRight) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        MappingStore mappingsComp = new MappingStore(rootSpoonLeft, rootSpoonRight);
        this.context = context;
        if (this.properties != null) {
            this.matcher.configure(this.properties);
        }
        MappingStore mappings = this.matcher.match(rootSpoonLeft, rootSpoonRight, mappingsComp);
        ChawatheScriptGenerator actionGenerator = new ChawatheScriptGenerator();
        EditScript edComplete = actionGenerator.computeActions(mappings);
        this.allOperations = this.convertToSpoon(edComplete.asList(), mappings);
        SimplifiedChawatheScriptGenerator actionGeneratorSimplified = new SimplifiedChawatheScriptGenerator();
        EditScript edSimplified = actionGeneratorSimplified.computeActions(mappings);
        this.simplifiedOperations = this.convertToSpoon(edSimplified.asList(), mappings);
        ActionClassifier actionClassifier = new ActionClassifier(mappings, edComplete.asList());
        this.rootOperations = this.convertToSpoon(actionClassifier.getRootActions(), mappings);
        this._mappingsComp = mappingsComp;
        for (int i = 0; i < this.getAllOperations().size(); ++i) {
            Operation operation = this.getAllOperations().get(i);
            if (!(operation instanceof MoveOperation)) continue;
            if (operation.getSrcNode() != null) {
                operation.getSrcNode().putMetadata("isMoved", (Object)true);
            }
            if (operation.getDstNode() == null) continue;
            operation.getDstNode().putMetadata("isMoved", (Object)true);
        }
    }

    private List<Operation> convertToSpoon(List<Action> actions, MappingStore mappings) {
        List<Operation> collect = actions.stream().map(action -> {
            action.getNode().setMetadata("type", (Object)action.getNode().getType().name);
            Tree original = action.getNode();
            if (action instanceof Insert) {
                return new InsertOperation((Insert)action);
            }
            if (action instanceof Delete) {
                return new DeleteOperation((Delete)action);
            }
            if (action instanceof Update) {
                this.setSpoonDestinationInTree(mappings, original);
                UpdateOperation updateOperation = new UpdateOperation((Update)action);
                return updateOperation;
            }
            if (action instanceof Move) {
                this.setSpoonDestinationInTree(mappings, original);
                MoveOperation moveOperation = new MoveOperation((Move)action);
                return moveOperation;
            }
            if (action instanceof TreeInsert) {
                return new InsertTreeOperation((TreeInsert)action);
            }
            if (action instanceof TreeDelete) {
                return new DeleteTreeOperation((TreeDelete)action);
            }
            throw new IllegalArgumentException("Please support the new type " + action.getClass());
        }).collect(Collectors.toList());
        return collect;
    }

    public void setSpoonDestinationInTree(MappingStore mappings, Tree original) {
        Tree dest = mappings.getDstForSrc(original);
        original.setMetadata("spoon_object_dest", dest.getMetadata("spoon_object"));
    }

    @Override
    public List<Operation> getAllOperations() {
        return Collections.unmodifiableList(this.allOperations);
    }

    @Override
    public List<Operation> getRootOperations() {
        return Collections.unmodifiableList(this.rootOperations);
    }

    @Override
    public List<Operation> getOperationChildren(Operation operationParent, List<Operation> rootOperations) {
        return rootOperations.stream().filter(operation -> operation.getNode().getParent().equals(operationParent)).collect(Collectors.toList());
    }

    @Override
    public CtElement changedNode() {
        if (this.rootOperations.size() != 1) {
            throw new IllegalArgumentException("Should have only one root action.");
        }
        return this.commonAncestor();
    }

    @Override
    public CtElement commonAncestor() {
        ArrayList<CtElement> copy = new ArrayList<CtElement>();
        for (Operation operation : this.rootOperations) {
            CtElement el = operation.getNode();
            if (operation instanceof InsertOperation) {
                Tree parentTree = operation.getAction().getNode().getParent();
                Tree mappedSrcParent = this._mappingsComp.getSrcForDst(parentTree);
                el = (CtElement)mappedSrcParent.getMetadata("spoon_object");
            }
            copy.add(el);
        }
        while (copy.size() >= 2) {
            CtElement first = (CtElement)copy.remove(0);
            CtElement second = (CtElement)copy.remove(0);
            copy.add(this.commonAncestor(first, second));
        }
        return (CtElement)copy.get(0);
    }

    private CtElement commonAncestor(CtElement first, CtElement second) {
        while (first != null) {
            for (CtElement el = second; el != null; el = el.getParent()) {
                if (first != el) continue;
                return first;
            }
            first = first.getParent();
        }
        return null;
    }

    @Override
    public CtElement changedNode(Class<? extends Operation> operationWanted) {
        Optional<Operation> firstNode = this.rootOperations.stream().filter(operation -> operationWanted.isAssignableFrom(operation.getClass())).findFirst();
        if (firstNode.isPresent()) {
            return firstNode.get().getNode();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean containsOperation(OperationKind kind, String nodeKind) {
        return this.rootOperations.stream().anyMatch(operation -> operation.getAction().getClass().getSimpleName().equals(kind.name()) && operation.getAction().getNode().getType().name.equals(nodeKind));
    }

    @Override
    public boolean containsOperation(OperationKind kind, String nodeKind, String nodeLabel) {
        return this.containsOperations(this.getRootOperations(), kind, nodeKind, nodeLabel);
    }

    @Override
    public boolean containsOperations(List<Operation> operations, OperationKind kind, String nodeKind, String nodeLabel) {
        return operations.stream().anyMatch(operation -> operation.getAction().getClass().getSimpleName().equals(kind.name()) && operation.getAction().getNode().getType().name.equals(nodeKind) && operation.getAction().getNode().getLabel().equals(nodeLabel));
    }

    @Override
    public boolean containsOperations(OperationKind kind, String nodeKind, String nodeLabel, String newLabel) {
        if (kind != OperationKind.Update) {
            throw new IllegalArgumentException();
        }
        return this.getRootOperations().stream().anyMatch(operation -> operation instanceof UpdateOperation && ((Update)((UpdateOperation)operation).getAction()).getNode().getLabel().equals(nodeLabel) && ((Update)((UpdateOperation)operation).getAction()).getValue().equals(newLabel));
    }

    @Override
    public void debugInformation() {
        System.err.println(this.toDebugString());
    }

    private String toDebugString() {
        return this.toDebugString(this.rootOperations);
    }

    private String toDebugString(List<Operation> ops) {
        Object result = "";
        for (Operation operation : ops) {
            Tree node = operation.getAction().getNode();
            CtElement nodeElement = operation.getNode();
            Object nodeType = node.getType().name;
            if (nodeElement != null) {
                nodeType = (String)nodeType + "(" + nodeElement.getClass().getSimpleName() + ")";
            }
            result = (String)result + "OperationKind." + operation.getAction().getClass().getSimpleName() + ", \"" + (String)nodeType + "\", \"" + node.getLabel() + "\"";
            if (operation instanceof UpdateOperation) {
                result = (String)result + ",  \"" + ((Update)operation.getAction()).getValue() + "\"";
            }
            result = (String)result + " (size: " + node.getDescendants().size() + ")" + node.toTreeString();
        }
        return result;
    }

    public String toString() {
        if (this.rootOperations.size() == 0) {
            return "no AST change";
        }
        StringBuilder stringBuilder = new StringBuilder();
        CtElement ctElement = this.commonAncestor();
        for (Operation operation : this.rootOperations) {
            stringBuilder.append(operation.toString());
            if (!operation.getSrcNode().equals(ctElement) || !(operation instanceof UpdateOperation)) continue;
            break;
        }
        return stringBuilder.toString();
    }

    public TreeContext getContext() {
        return this.context;
    }

    @Override
    public MappingStore getMappingsComp() {
        return this._mappingsComp;
    }

    @Override
    public boolean containsOperations(List<Operation> operations, OperationKind kind, String nodeKind) {
        return operations.stream().anyMatch(operation -> operation.getAction().getClass().getSimpleName().equals(kind.name()) && operation.getAction().getNode().getType().name.equals(nodeKind));
    }
}

