/*
 * Decompiled with CFR 0.152.
 */
package gumtree.spoon.diff.operations;

import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.actions.model.Move;
import com.github.gumtreediff.actions.model.Update;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;

public abstract class Operation<T extends Action> {
    private final CtElement node;
    private final T action;

    public Operation(T action) {
        this.action = action;
        this.node = (CtElement)action.getNode().getMetadata("spoon_object");
    }

    @Deprecated
    public CtElement getNode() {
        return this.node;
    }

    public T getAction() {
        return this.action;
    }

    public String toString() {
        return this.toStringAction((Action)this.action);
    }

    private String toStringAction(Action action) {
        String[] split;
        String newline = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(action.getClass().getSimpleName());
        CtElement element = this.node;
        if (element == null) {
            return stringBuilder.toString() + " fake_node(" + action.getNode().getMetadata("type") + ")";
        }
        String nodeType = element.getClass().getSimpleName();
        nodeType = nodeType.substring(2, nodeType.length() - 4);
        stringBuilder.append(" ").append(nodeType);
        CtElement parent = element;
        while (parent.getParent() != null && !(parent.getParent() instanceof CtPackage)) {
            parent = parent.getParent();
        }
        Object position = " at ";
        if (parent instanceof CtType) {
            position = (String)position + ((CtType)parent).getQualifiedName();
        }
        if (element.getPosition() != null && !(element.getPosition() instanceof NoSourcePosition)) {
            position = (String)position + ":" + element.getPosition().getLine();
        }
        if (action instanceof Move) {
            CtElement elementDest = (CtElement)action.getNode().getMetadata("spoon_object_dest");
            position = " from " + ((CtType)element.getParent(CtType.class)).getQualifiedName();
            if (element.getPosition() != null && !(element.getPosition() instanceof NoSourcePosition)) {
                position = (String)position + ":" + element.getPosition().getLine();
            }
            position = (String)position + " to " + ((CtType)elementDest.getParent(CtType.class)).getQualifiedName();
            if (elementDest.getPosition() != null && !(elementDest.getPosition() instanceof NoSourcePosition)) {
                position = (String)position + ":" + elementDest.getPosition().getLine();
            }
        }
        stringBuilder.append((String)position).append(newline);
        Object label = this.partialElementPrint(element);
        if (action instanceof Move) {
            label = element.toString();
        }
        if (action instanceof Update) {
            CtElement elementDest = (CtElement)action.getNode().getMetadata("spoon_object_dest");
            label = (String)label + " to " + elementDest.toString();
        }
        for (String s : split = ((String)label).split(newline)) {
            stringBuilder.append("\t").append(s).append(newline);
        }
        return stringBuilder.toString();
    }

    private String partialElementPrint(CtElement element) {
        DefaultJavaPrettyPrinter print = new DefaultJavaPrettyPrinter(element.getFactory().getEnvironment()){

            public DefaultJavaPrettyPrinter scan(CtElement e) {
                if (e != null && e.getMetadata("isMoved") == null) {
                    return super.scan(e);
                }
                return this;
            }
        };
        print.scan(element);
        return print.getResult();
    }

    public CtElement getSrcNode() {
        return this.node;
    }

    public CtElement getDstNode() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }
}

